/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common;

import com.huawei.dc.common.components.treetable.model.TreeTableCellData;
import com.huawei.dc.common.components.treetable.view.DCSortableTreeTable;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.taskmgmt.isolation.IsolationCommonOperation;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class MyMouseMotionAdapter
extends MouseMotionAdapter {
    private DCSortableTreeTable m_oTaskTreeTable;

    public MyMouseMotionAdapter(DCSortableTreeTable oTaskTreeTable) {
        this.m_oTaskTreeTable = oTaskTreeTable;
    }

    @Override
    public void mouseMoved(MouseEvent oMouseEvent) {
        Point oPoint = oMouseEvent.getPoint();
        if (this.m_oTaskTreeTable.columnAtPoint(oPoint) == 8) {
            Object oValue = this.m_oTaskTreeTable.getValueAt(this.m_oTaskTreeTable.rowAtPoint(oPoint), 8);
            if (oValue instanceof TreeTableCellData) {
                Object oCellVal = ((TreeTableCellData)oValue).getCellDataValue();
                if (oCellVal instanceof ResourceProgressInfo) {
                    ResourceProgressInfo oResProgress = (ResourceProgressInfo)oCellVal;
                    if (DCHelpForErrCodeUtil.isShowHyperlink(oResProgress.getErrorNo()) || IsolationCommonOperation.isIsolationState(oResProgress)) {
                        Cursor cur = new Cursor(12);
                        DCFrameWorkUtil.setCursor(cur);
                    } else {
                        Cursor cur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(cur);
                    }
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(cur);
                }
            } else {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(cur);
            }
        } else {
            Cursor cur = new Cursor(0);
            DCFrameWorkUtil.setCursor(cur);
        }
    }

    public void clearUp() {
        this.m_oTaskTreeTable = null;
    }
}

