/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common;

import com.huawei.dc.common.dcmodule.DataCenterModuleForAppModule;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.u2000.framework.adaptive.AdaptiveUtil;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.framework.applicationfavourites.FavouriteButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class MainMenuAuthorityAction
extends AuthorityAction {
    private static final long serialVersionUID = -3243440901358546776L;
    private Map<String, Boolean> m_oRightMap;
    private Map<String, Boolean> m_oIsVisibleMap;
    private boolean m_isFinishCheckRight = false;
    private boolean m_isFinishVerifyPlugin = false;
    private static final String TRANS_COMMON = "trans_common";
    private static final String ACCESS = "access";
    private static final String NEMGR_ROUTER = "nemgr_router";

    public MainMenuAuthorityAction() {
        DCDebugTracer.trace("DC::MainMenuAuthorityAction");
        this.m_oRightMap = new HashMap<String, Boolean>();
        this.m_oIsVisibleMap = new HashMap<String, Boolean>();
    }

    private void verifyPluginModeMenu() {
        this.m_isFinishVerifyPlugin = true;
        DCDebugTracer.trace("MainMenuAuthorityAction#verifyPluginModeMenu start");
        if (!DCFrameWorkUtil.isPluginMode()) {
            DCDebugTracer.trace("MainMenuAuthorityAction#verifyPluginModeMenu end..");
            return;
        }
        if (!AdaptiveUtil.isSubsystemDeployed((String)TRANS_COMMON)) {
            this.m_oIsVisibleMap.put("OnlineBoardUpgrade", false);
            this.m_oIsVisibleMap.put("loadBoardSoft", false);
            this.m_oIsVisibleMap.put("loadBoardPatch", false);
            this.m_oIsVisibleMap.put("tkLicense", false);
            this.m_oIsVisibleMap.put("tkBacupLog", false);
            this.m_oIsVisibleMap.put("showTL1Frame", false);
        }
        if (!AdaptiveUtil.isSubsystemDeployed((String)ACCESS) || !AdaptiveUtil.isSubsystemDeployed((String)NEMGR_ROUTER)) {
            this.m_oIsVisibleMap.put("MXUPolicy", false);
        }
        DCDebugTracer.trace("MainMenuAuthorityAction#verifyPluginModeMenu end..");
    }

    private void verifyPluginModeMenuInPortal() {
        if (DataCenterModuleForAppModule.getInstance().isComponentDisable("dc", 1)) {
            DCDebugTracer.trace("MainMenuAuthorityAction#verifyPluginModeMenuInPortal Start");
            this.mainMenuVisable(false);
            DCDebugTracer.trace("MainMenuAuthorityAction#verifyPluginModeMenuInPortal end");
        }
    }

    private void mainMenuVisable(boolean isVisible) {
        this.m_oIsVisibleMap.put("DeviceOperation", isVisible);
        this.m_oIsVisibleMap.put("TaskManagement", isVisible);
        this.m_oIsVisibleMap.put("SoftwareArchiveManagement", isVisible);
        this.m_oIsVisibleMap.put("BackupPolicyManagement", isVisible);
        this.m_oIsVisibleMap.put("OnlineBoardUpgrade", isVisible);
        this.m_oIsVisibleMap.put("browseLog", isVisible);
        this.m_oIsVisibleMap.put("MXUPolicy", isVisible);
        this.m_oIsVisibleMap.put("SystemSetting", isVisible);
        this.m_oIsVisibleMap.put("Import License File", isVisible);
        this.m_oIsVisibleMap.put("loadBoardSoft", isVisible);
        this.m_oIsVisibleMap.put("loadBoardPatch", isVisible);
        this.m_oIsVisibleMap.put("tkLicense", isVisible);
        this.m_oIsVisibleMap.put("tkBacupLog", isVisible);
        this.m_oIsVisibleMap.put("showTL1Frame", isVisible);
        this.m_oIsVisibleMap.put("serviceManagement", isVisible);
    }

    private void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_oRightMap.put("DeviceOperation", true);
        this.m_oRightMap.put("TaskManagement", true);
        this.m_oRightMap.put("SoftwareArchiveManagement", true);
        this.m_oRightMap.put("BackupPolicyManagement", true);
        this.m_oRightMap.put("OnlineBoardUpgrade", DCFrameWorkUtil.hasUserOperationPrivilege(43960));
        this.m_oRightMap.put("browseLog", DCFrameWorkUtil.hasUserOperationPrivilege(43818));
        this.m_oRightMap.put("MXUPolicy", DCFrameWorkUtil.hasUserOperationPrivilege(43972));
        this.m_oRightMap.put("SystemSetting", DCFrameWorkUtil.hasUserOperationPrivilege(43901));
        this.m_oRightMap.put("Import License File", DCFrameWorkUtil.hasUserOperationPrivilege(43924));
        this.m_oRightMap.put("loadBoardSoft", DCFrameWorkUtil.hasUserOperationPrivilege(44019));
        this.m_oRightMap.put("loadBoardPatch", DCFrameWorkUtil.hasUserOperationPrivilege(44020));
        this.m_oRightMap.put("tkLicense", DCFrameWorkUtil.hasUserOperationPrivilege(44021));
        this.m_oRightMap.put("tkBacupLog", DCFrameWorkUtil.hasUserOperationPrivilege(44022));
        this.m_oRightMap.put("showTL1Frame", DCFrameWorkUtil.hasUserOperationPrivilege(44045));
        this.m_oRightMap.put("serviceManagement", DCFrameWorkUtil.hasUserOperationPrivilege(44036));
        this.m_isFinishCheckRight = true;
    }

    public void actionPerformed(ActionEvent actionevent) {
    }

    public boolean isActionEnabled() {
        this.checkUserPrivileges();
        Component oMenuItemObj = this.getSource();
        if (oMenuItemObj instanceof MenuItem) {
            MenuItem oMenuItem = (MenuItem)oMenuItemObj;
            Boolean isHaveRight = this.m_oRightMap.get(oMenuItem.getID());
            DCDebugTracer.trace("MainMenuAuthorityAction#isActionEnabled#MenuItem+" + oMenuItem.getID() + ":" + isHaveRight);
            if (null != isHaveRight) {
                return isHaveRight;
            }
        } else if (oMenuItemObj instanceof FavouriteButton) {
            FavouriteButton oFavouriteButton = (FavouriteButton)oMenuItemObj;
            Boolean isHaveRight = this.m_oRightMap.get(oFavouriteButton.getMenuID());
            DCDebugTracer.trace("MainMenuAuthorityAction#isActionEnabled#FavouriteButton+" + oFavouriteButton.getMenuID() + ":" + isHaveRight);
            if (null != isHaveRight) {
                return isHaveRight;
            }
        }
        return false;
    }

    public boolean isActionVisible() {
        this.verifyPluginModeMenu();
        this.verifyPluginModeMenuInPortal();
        Component oMenuItemObj = this.getSource();
        if (oMenuItemObj instanceof MenuItem) {
            MenuItem oMenuItem = (MenuItem)oMenuItemObj;
            Boolean isVisible = this.m_oIsVisibleMap.get(oMenuItem.getID());
            DCDebugTracer.trace("MainMenuAuthorityAction#isActionVisible#MenuItem+" + oMenuItem.getID() + ":" + isVisible);
            if (null != isVisible) {
                return isVisible;
            }
        } else if (oMenuItemObj instanceof FavouriteButton) {
            FavouriteButton oFavouriteButton = (FavouriteButton)oMenuItemObj;
            Boolean isVisible = this.m_oIsVisibleMap.get(oFavouriteButton.getMenuID());
            DCDebugTracer.trace("MainMenuAuthorityAction#isActionVisible#MenuItem+" + oFavouriteButton.getMenuID() + ":" + isVisible);
            if (null != isVisible) {
                return isVisible;
            }
        }
        return true;
    }
}

