/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cmf.dc.customoperation.devicetab;

import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileMsg;
import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileTbl;
import com.huawei.cmf.dc.customoperation.asn1.AsnUpgradeFileInfoList;
import com.huawei.cmf.dc.customoperation.constant.CustomerInfoManager;
import com.huawei.cmf.dc.customoperation.devicetab.CustomOperationPara;
import com.huawei.cmf.dc.customoperation.devicetab.DeviceTabModulePanel;
import com.huawei.cmf.dc.customoperation.devicetab.VisualData;
import com.huawei.dc.common.asndatacenter.FStruDecoderFixUTC;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IOperationPara;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class LicenceFilePanel
extends DeviceTabModulePanel {
    private static final long serialVersionUID = -3552958669915371374L;

    public LicenceFilePanel() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter LicenceFilePanel.LicenceFilePanel()");
        this.initializeButtonToDefaultSettings();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.queryBtn, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.buttonPanel, "North");
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit LicenceFilePanel.LicenceFilePanel()");
        int iDevID = this.getSelectedDevID();
        if (-1 == iDevID) {
            return;
        }
        AsnGetStructUpgradeFileMsg oData = CustomerInfoManager.getInstance().getLicenceInfo(iDevID);
        if (null != oData) {
            this.refreshData(oData);
            this.updateCusUI(this);
        }
    }

    public void initGUI() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter LicenceFilePanel.initGUI()");
        if (null == this.tableHeaders) {
            String licenceFileName = this.oCustomResManager.getResString("LicenceFileName");
            String fileLocation = this.oCustomResManager.getResString("LicenceFileLocation");
            String fileSize = this.oCustomResManager.getResString("LicenceFileSize");
            this.tableHeaders = new String[]{licenceFileName, fileLocation, fileSize};
            this.init(this.tableHeaders, new int[]{0, 1, 2});
        }
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit LicenceFilePanel.initGUI()");
    }

    @Override
    public void updateTab() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter LicenceFilePanel.updateTab()");
        int iTotalDevice = this.deviceInfos.length;
        String iOperationID = "GetLicenceFileInfo";
        IOperationPara[] operationParas = new CustomOperationPara[iTotalDevice];
        for (int i = 0; i < iTotalDevice; ++i) {
            operationParas[i] = new CustomOperationPara();
            ((CustomOperationPara)operationParas[i]).setDeviceID(this.deviceInfos[i].getDevID());
        }
        this.customExcutor.setOperationParas(iOperationID, operationParas);
        this.customExcutor.execute();
        this.setRefreshBtnState(false);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit LicenceFilePanel.updateTab()");
    }

    @Override
    public void notifyMessage(ICustomOperationEvent event) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter LicenceFilePanel.notifyMessage()");
        String iOperationID = event.getOperationID();
        if (null == iOperationID || !iOperationID.equals("GetLicenceFileInfo")) {
            DCDebugTracer.trace(3, "CommHandleMgr", "OperationID is wrong", iOperationID);
            return;
        }
        this.deviceInfos = event.getDeviceInfo();
        byte[] msgResult = event.getResult();
        if (event.getiFailureReason() != -1) {
            this.showErrDesc(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(event.getiFailureReason())));
            this.updateCusUI(this);
            return;
        }
        AsnGetStructUpgradeFileMsg asnGetStructUpgradeFileMsg = new AsnGetStructUpgradeFileMsg();
        if (msgResult != null && msgResult.length != 0) {
            DCDebugTracer.trace(3, "CommHandleMgr", "", "AsnGetStructUpgradeFileMsg is Null");
            FStruDecoderFixUTC deccoder = new FStruDecoderFixUTC(msgResult);
            try {
                asnGetStructUpgradeFileMsg.deserialize((Decoder)deccoder);
                DCDebugTracer.trace(3, "AsnCoder", "decode()", "decode succeed");
                int iDevID = this.deviceInfos[0].getDevID();
                CustomerInfoManager.getInstance().addCustomerInfo(2, iDevID, asnGetStructUpgradeFileMsg);
                this.tableHeaders = null;
                this.refreshData(asnGetStructUpgradeFileMsg);
                this.updateCusUI(this);
            }
            catch (FStruException e) {
                DCDebugTracer.trace(3, "AsnCoder", "decode()", "decode failed");
                DCDebugTracer.trace((Exception)((Object)e));
            }
        }
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit LicenceFilePanel.notifyMessage()");
    }

    public void refreshData(FStruct data) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter LicenceFilePanel.refreshData()");
        AsnGetStructUpgradeFileMsg AsnDataMsg = (AsnGetStructUpgradeFileMsg)data;
        if (null == AsnDataMsg) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "AsnDataMsg is null");
            return;
        }
        if (0 != AsnDataMsg.errorCode.intValue()) {
            String strErrDesc = null;
            strErrDesc = this.cusErrorCodeReader.getErrorDesc(AsnDataMsg.errorCode);
            this.showErrDesc(strErrDesc);
            DCDebugTracer.trace(3, "CommHandleMgr", "get config info operation is failed:", strErrDesc);
            return;
        }
        if (null == AsnDataMsg.upgradeFileInfo || 0 == AsnDataMsg.upgradeFileInfo.size()) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "None refresh data");
            return;
        }
        AsnUpgradeFileInfoList asnUpgradeFileInfoList = AsnDataMsg.upgradeFileInfo;
        int size = AsnDataMsg.upgradeFileInfo.size();
        Object[][] updateData = new Object[size][3];
        AsnGetStructUpgradeFileTbl asnOneUpgradeFileTbl = null;
        for (int index = 0; index < size; ++index) {
            asnOneUpgradeFileTbl = (AsnGetStructUpgradeFileTbl)asnUpgradeFileInfoList.get(index);
            if (null == asnOneUpgradeFileTbl) {
                DCDebugTracer.trace(1, "AsnCoder", "decode()", "there is a recore is null");
                continue;
            }
            this.initGUI();
            Object[] currRow = new Object[]{this.getStringValue(asnOneUpgradeFileTbl.sysFileName), this.getStringValue(asnOneUpgradeFileTbl.sysFileLocation), new VisualData(asnOneUpgradeFileTbl.sysFileSize, asnOneUpgradeFileTbl.sysFileSize.toString())};
            updateData[index] = currRow;
        }
        this.tblModel.getDataVector().clear();
        this.tblModel.addRows(updateData);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit LicenceFilePanel.refreshData()");
    }

    private void updateCusUI(final JPanel parent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                parent.updateUI();
            }
        });
    }
}

