/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cmf.dc.customoperation.devicetab;

import com.huawei.cmf.dc.customoperation.asn1.AsnGetSpaceInfoMsg;
import com.huawei.cmf.dc.customoperation.asn1.AsnGetSpaceInfoTbl;
import com.huawei.cmf.dc.customoperation.asn1.AsnSpaceInfoList;
import com.huawei.cmf.dc.customoperation.constant.CustomerInfoManager;
import com.huawei.cmf.dc.customoperation.devicetab.CustomOperationPara;
import com.huawei.cmf.dc.customoperation.devicetab.DeviceTabModulePanel;
import com.huawei.cmf.dc.customoperation.devicetab.VisualData;
import com.huawei.dc.common.asndatacenter.FStruDecoderFixUTC;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IOperationPara;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class DiskSizeInfoPanel
extends DeviceTabModulePanel {
    private static final long serialVersionUID = 2181071893775739501L;

    public DiskSizeInfoPanel() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DiskSizeInfoPanel.DiskSizeInfoPanel()");
        this.initializeButtonToDefaultSettings();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.queryBtn, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.buttonPanel, "North");
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DiskSizeInfoPanel.DiskSizeInfoPanel()");
        int iDevID = this.getSelectedDevID();
        if (-1 == iDevID) {
            return;
        }
        AsnGetSpaceInfoMsg oData = CustomerInfoManager.getInstance().getDiskInfo(iDevID);
        if (null != oData) {
            this.refreshData(oData);
            this.updateCusUI(this);
        }
    }

    public void initGUI() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.initGUI()");
        if (null == this.tableHeaders) {
            String diskName = this.oCustomResManager.getResString("DiskName");
            String diskType = this.oCustomResManager.getResString("DiskType");
            String TotalSize = this.oCustomResManager.getResString("DiskTotalSize");
            String remainSize = this.oCustomResManager.getResString("DiskRemainSize");
            this.tableHeaders = new String[]{diskName, diskType, TotalSize, remainSize};
            this.init(this.tableHeaders, new int[]{0, 1, 2, 3});
        }
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DiskSizeInfoPanel.initGUI()");
    }

    @Override
    public void updateTab() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DiskSizeInfoPanel.updateTab()");
        int iTotalDevice = this.deviceInfos.length;
        String iOperationID = "GetDiskInfo";
        IOperationPara[] operationParas = new CustomOperationPara[iTotalDevice];
        for (int i = 0; i < iTotalDevice; ++i) {
            operationParas[i] = new CustomOperationPara();
            ((CustomOperationPara)operationParas[i]).setDeviceID(this.deviceInfos[i].getDevID());
        }
        this.customExcutor.setOperationParas(iOperationID, operationParas);
        this.customExcutor.execute();
        this.setRefreshBtnState(false);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DiskSizeInfoPanel.updateTab()");
    }

    @Override
    public void notifyMessage(ICustomOperationEvent event) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DiskSizeInfoPanel.notifyMessage()");
        String iOperationID = event.getOperationID();
        if (null == iOperationID || !iOperationID.equals("GetDiskInfo")) {
            DCDebugTracer.trace(3, "CommHandleMgr", "OperationID is wrong", iOperationID);
            return;
        }
        this.deviceInfos = event.getDeviceInfo();
        byte[] msgResult = event.getResult();
        if (event.getiFailureReason() != -1) {
            this.showErrDesc(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(event.getiFailureReason())));
            this.updateCusUI(this);
            return;
        }
        AsnGetSpaceInfoMsg asnGetSpaceInfoMsg = new AsnGetSpaceInfoMsg();
        if (msgResult != null && msgResult.length != 0) {
            DCDebugTracer.trace(3, "CommHandleMgr", "", "AsnGetStructUpgradeFileMsg is Null");
            FStruDecoderFixUTC deccoder = new FStruDecoderFixUTC(msgResult);
            try {
                asnGetSpaceInfoMsg.deserialize((Decoder)deccoder);
                DCDebugTracer.trace(3, "AsnCoder", "decode()", "decode succeed");
                int iDevID = this.deviceInfos[0].getDevID();
                CustomerInfoManager.getInstance().addCustomerInfo(1, iDevID, asnGetSpaceInfoMsg);
                this.refreshData(asnGetSpaceInfoMsg);
                this.updateCusUI(this);
            }
            catch (FStruException e) {
                DCDebugTracer.trace(3, "AsnCoder", "decode()", "decode failed");
                DCDebugTracer.trace((Exception)((Object)e));
            }
        }
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DiskSizeInfoPanel.notifyMessage()");
    }

    public void refreshData(FStruct data) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DiskSizeInfoPanel.refreshData()");
        AsnGetSpaceInfoMsg AsnDataMsg = (AsnGetSpaceInfoMsg)data;
        if (null == AsnDataMsg) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "AsnDataMsg is null");
            return;
        }
        if (0 != AsnDataMsg.errorCode.intValue() && 999292979L != (long)AsnDataMsg.errorCode.intValue()) {
            String strErrDesc = null;
            strErrDesc = this.cusErrorCodeReader.getErrorDesc(AsnDataMsg.errorCode);
            this.showErrDesc(strErrDesc);
            DCDebugTracer.trace(3, "CommHandleMgr", "get config info operation is failed:", strErrDesc);
            return;
        }
        if (999292979L == (long)AsnDataMsg.errorCode.intValue()) {
            String strErrDesc = null;
            strErrDesc = this.cusErrorCodeReader.getErrorDesc(AsnDataMsg.errorCode);
            this.showErrDesc(strErrDesc);
            String diskName = this.oCustomResManager.getResString("DiskName");
            String diskType = this.oCustomResManager.getResString("DiskType");
            String TotalSize = this.oCustomResManager.getResString("DiskTotalSize");
            String remainSize = this.oCustomResManager.getResString("DiskRemainSize");
            this.tableHeaders = new String[]{diskName, diskType, TotalSize, remainSize};
            this.init(this.tableHeaders, new int[]{0, 1, 2, 3});
            DCDebugTracer.trace(3, "CommHandleMgr", "The device only support to view flash", strErrDesc);
        }
        if (0 == AsnDataMsg.errorCode.intValue()) {
            DCDebugTracer.trace(3, "CommHandleMgr", "operation is success", "");
            this.initGUI();
        }
        if (null == AsnDataMsg.spaceInfo || 0 == AsnDataMsg.spaceInfo.size()) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "None refresh data");
            return;
        }
        AsnSpaceInfoList asnSpaceInfoList = AsnDataMsg.spaceInfo;
        int size = AsnDataMsg.spaceInfo.size();
        Object[][] updateData = new Object[size][4];
        AsnGetSpaceInfoTbl asnOneSpaceInfoTbl = null;
        for (int index = 0; index < size; ++index) {
            asnOneSpaceInfoTbl = (AsnGetSpaceInfoTbl)asnSpaceInfoList.get(index);
            if (null == asnOneSpaceInfoTbl) {
                DCDebugTracer.trace(1, "AsnCoder", "decode()", "there is a recore is null");
                continue;
            }
            long totalSpace = (long)asnOneSpaceInfoTbl.totalSpace.intValue() * 1024L;
            String totalSpaceStr = String.valueOf(totalSpace);
            long spaceFree = (long)asnOneSpaceInfoTbl.spaceFree.intValue() * 1024L;
            String spaceFreeStr = String.valueOf(spaceFree);
            Object[] currRow = new Object[]{this.getStringValue(asnOneSpaceInfoTbl.storageName), this.getStringValue(asnOneSpaceInfoTbl.storageType), new VisualData(new BigInteger(totalSpaceStr), totalSpaceStr), new VisualData(new BigInteger(spaceFreeStr), spaceFreeStr)};
            updateData[index] = currRow;
        }
        this.tblModel.getDataVector().clear();
        this.tblModel.addRows(updateData);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DiskSizeInfoPanel.refreshData()");
    }

    private void updateCusUI(final JPanel parent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                parent.updateUI();
            }
        });
    }
}

