/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cmf.dc.customoperation.devicetab;

import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileMsg;
import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileTbl;
import com.huawei.cmf.dc.customoperation.asn1.AsnUpgradeFileInfoList;
import com.huawei.cmf.dc.customoperation.constant.CustomerInfoManager;
import com.huawei.cmf.dc.customoperation.devicetab.CustomOperationPara;
import com.huawei.cmf.dc.customoperation.devicetab.DeviceTabModulePanel;
import com.huawei.cmf.dc.customoperation.devicetab.VisualData;
import com.huawei.dc.common.asndatacenter.AsnCustomOpInfo;
import com.huawei.dc.common.asndatacenter.AsnCustomOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnCustomOpPara;
import com.huawei.dc.common.asndatacenter.AsnCustomOpParaLst;
import com.huawei.dc.common.asndatacenter.AsnCustomOpReq;
import com.huawei.dc.common.asndatacenter.AsnCustomOpRsp;
import com.huawei.dc.common.asndatacenter.AsnDCBackupAndSAMReq;
import com.huawei.dc.common.asndatacenter.AsnDCCustomBackupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDevTypeIdInfo;
import com.huawei.dc.common.asndatacenter.AsnImportModeEnum;
import com.huawei.dc.common.asndatacenter.AsnSAMT2000FileLst;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.FStruDecoderFixUTC;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.BusyDeviceObjectStore;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IOperationPara;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import com.huawei.dc.sam.view.SAMFileInfoImportPanelHelper;
import com.huawei.dc.taskmgmt.controller.TaskCommUtil;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.SyncCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class DevMapProgramPanel
extends DeviceTabModulePanel {
    private static final long serialVersionUID = -4510713938385708579L;
    private JPopupMenu m_oPopupMenu;
    private String m_oYes;
    private String m_oNo;
    private BaseCommManager m_oCommManager;
    private static final String PROGRAMID = "PROGRAM";
    public static final String IMAGENAME_PARAID = "ImageName";
    public static final String IMAGELOCATION_PARAID = "ImageLocation";
    public static final String DELETE_IMAGE = "DeleteImage";
    private boolean backupImageFilesPrivilege;
    private boolean deleteImageFilesPrivilege;
    private boolean bIsSecurityDev;
    private boolean bIsSRGDev;
    private static final int YES_FLAG = 1;
    private static final int NO_FLAG = 0;
    private static final int NOT_SUPPORT_FLAG = -1;

    public DevMapProgramPanel() {
        this.m_oYes = this.oCustomResManager.getResString("yes");
        this.m_oNo = this.oCustomResManager.getResString("no");
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
        this.backupImageFilesPrivilege = true;
        this.deleteImageFilesPrivilege = true;
        this.bIsSecurityDev = false;
        this.bIsSRGDev = false;
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.DevMapProgramPanel()");
        this.initializeButtonToDefaultSettings();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.queryBtn, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.buttonPanel, "North");
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            this.backupImageFilesPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43986);
            this.deleteImageFilesPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43941);
        }
        DCHelpManager.getInstance().enableHelpKey(this, ResourceManager.getInstance().getResString("HELP_TOPIC_MANAGE_REFLECTION"));
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DevMapProgramPanel.DevMapProgramPanel()");
        int iDevID = this.getSelectedDevID();
        if (-1 == iDevID) {
            return;
        }
        DeviceInfo dev = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
        this.bIsSecurityDev = ResourceManager.getInstance().isSecurityDevDevType(dev.getDeviceTypeInfo());
        this.bIsSRGDev = ResourceManager.getInstance().isDevInSpecDevSeries(ResourceManager.getInstance().getResString("SRG_Series"), String.valueOf(dev.getDeviceTypeInfo().getDevTypeID()));
        AsnGetStructUpgradeFileMsg oData = CustomerInfoManager.getInstance().getDevMapInfo(iDevID);
        if (null != oData) {
            this.refreshData(oData);
            this.updateCusUI(this);
        }
    }

    protected void initGUI(int iCurFile, int iNextFile) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.initGUI()");
        if (null == this.tableHeaders) {
            String ImageProgramFileName = this.oCustomResManager.getResString("ImageProgFileName");
            String fileLocation = this.oCustomResManager.getResString("ImageProgFileLocation");
            String fileSize = this.oCustomResManager.getResString("ImageProgFileSize");
            String programVersion = this.oCustomResManager.getResString("ImageProgVersion");
            String curFile = this.oCustomResManager.getResString("ImageProgCurFile");
            String nextFile = this.oCustomResManager.getResString("ImageProgNextFile");
            this.tableHeaders = new String[]{ImageProgramFileName, fileLocation, fileSize, programVersion, curFile, nextFile};
            this.init(this.tableHeaders, new int[]{0, 1, 2, 3, 4, 5});
        }
        if (-1 == iCurFile && this.table.getColumnModel().getColumn(4).getMinWidth() != 0) {
            this.table.getColumnModel().getColumn(4).setMinWidth(0);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(0);
            this.table.getColumnModel().getColumn(4).setMaxWidth(0);
        }
        if (-1 == iNextFile && this.table.getColumnModel().getColumn(5).getMinWidth() != 0) {
            this.table.getColumnModel().getColumn(5).setMinWidth(0);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(0);
            this.table.getColumnModel().getColumn(5).setMaxWidth(0);
        }
        this.table.addMouseListener((MouseListener)this.generateMouseAdapter());
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DevMapProgramPanel.initGUI()");
    }

    @Override
    public void updateTab() {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.updateTab()");
        int iTotalDevice = this.deviceInfos.length;
        String iOperationID = "GetDeviceMapProgramInfo";
        IOperationPara[] operationParas = new CustomOperationPara[iTotalDevice];
        for (int i = 0; i < iTotalDevice; ++i) {
            operationParas[i] = new CustomOperationPara();
            ((CustomOperationPara)operationParas[i]).setDeviceID(this.deviceInfos[i].getDevID());
        }
        this.customExcutor.setOperationParas(iOperationID, operationParas);
        this.customExcutor.execute();
        this.setRefreshBtnState(false);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DevMapProgramPanel.updateTab()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyMessage(ICustomOperationEvent event) {
        block12: {
            DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.notifyMessage()");
            String iOperationID = event.getOperationID();
            if (null == iOperationID) {
                return;
            }
            if (DELETE_IMAGE.equals(iOperationID) && event.getiFailureReason() != -1 || "BackupImage".equals(iOperationID)) {
                return;
            }
            AsnGetStructUpgradeFileMsg asnGetStructUpgradeFileMsg = new AsnGetStructUpgradeFileMsg();
            byte[] msgResult = null;
            this.deviceInfos = event.getDeviceInfo();
            msgResult = event.getResult();
            if (event.getiFailureReason() != -1) {
                this.showErrDesc(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(event.getiFailureReason())));
                this.updateCusUI(this);
                return;
            }
            if (msgResult != null && msgResult.length != 0) {
                FStruDecoderFixUTC deccoder = new FStruDecoderFixUTC(msgResult);
                try {
                    asnGetStructUpgradeFileMsg.deserialize((Decoder)deccoder);
                    if (!iOperationID.equals(DELETE_IMAGE)) {
                        if (iOperationID.equals("GetDeviceMapProgramInfo")) {
                            int iDevID = this.deviceInfos[0].getDevID();
                            CustomerInfoManager.getInstance().addCustomerInfo(0, iDevID, asnGetStructUpgradeFileMsg);
                            this.tableHeaders = null;
                            this.refreshData(asnGetStructUpgradeFileMsg);
                            this.updateCusUI(this);
                        }
                        break block12;
                    }
                    if (0 != asnGetStructUpgradeFileMsg.errorCode.intValue()) {
                        DCOptionPane.showWarningDialog(this, this.oCustomResManager.getResString("DELETEFAILEDINFO"), true);
                        return;
                    }
                    AsnUpgradeFileInfoList oAsnUpgradeFileInfoList = asnGetStructUpgradeFileMsg.upgradeFileInfo;
                    SortableTableModel oSortableTableModel = (SortableTableModel)this.table.getModel();
                    Vector oVectorLst = oSortableTableModel.getDataVector();
                    String sFileName = null;
                    String sFileLoc = null;
                    int[] rows = new int[oAsnUpgradeFileInfoList.size()];
                    int i = 0;
                    while (true) {
                        if (i >= oAsnUpgradeFileInfoList.size()) {
                            List<Object> oDataLst = this.getSelectDataLst(rows);
                            int iDevID = this.deviceInfos[0].getDevID();
                            CustomerInfoManager.getInstance().removeFileInfo(0, iDevID, oDataLst);
                            this.tblModel.removeSelectedRows(rows);
                            this.updateCusUI(this);
                            break;
                        }
                        AsnGetStructUpgradeFileTbl oAsnGetStructUpgradeFileTbl = (AsnGetStructUpgradeFileTbl)oAsnUpgradeFileInfoList.get(i);
                        sFileName = new String(oAsnGetStructUpgradeFileTbl.sysFileName);
                        sFileLoc = new String(oAsnGetStructUpgradeFileTbl.sysFileLocation);
                        for (int j = 0; j < oVectorLst.size(); ++j) {
                            Vector oVector = (Vector)oVectorLst.get(j);
                            String sFileNameOfTb = oVector.get(0).toString();
                            String sFielLocOfTb = oVector.get(1).toString();
                            if (!sFileName.equals(sFileNameOfTb) || !sFileLoc.equals(sFielLocOfTb)) continue;
                            rows[i] = j;
                            break;
                        }
                        ++i;
                    }
                }
                catch (FStruException e) {
                    DCDebugTracer.trace(3, "AsnCoder", "decode()", "decode failed");
                    DCDebugTracer.trace((Exception)((Object)e));
                }
            }
        }
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DevMapProgramPanel.notifyMessage()");
    }

    private List<Object> getSelectDataLst(int[] rows) {
        int iLen = rows.length;
        ArrayList<Object> oDataLst = new ArrayList<Object>();
        for (int i = 0; i < iLen; ++i) {
            Object oRowData = this.tblModel.getDataVector().get(rows[i]);
            oDataLst.add(oRowData);
        }
        return oDataLst;
    }

    public void refreshData(FStruct data) {
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Enter DevMapProgramPanel.refreshData()");
        AsnGetStructUpgradeFileMsg AsnDataMsg = (AsnGetStructUpgradeFileMsg)data;
        if (null == AsnDataMsg) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "AsnDataMsg is null");
            return;
        }
        if (0 != AsnDataMsg.errorCode.intValue()) {
            String strErrDesc = null;
            strErrDesc = this.cusErrorCodeReader.getErrorDesc(AsnDataMsg.errorCode);
            this.showErrDesc(strErrDesc);
            DCDebugTracer.trace(3, "CommHandleMgr", "get config info operation is failed:", strErrDesc);
            return;
        }
        if (null != this.oExceptionLable) {
            this.remove(this.oExceptionLable);
        }
        if (null == AsnDataMsg.upgradeFileInfo || 0 == AsnDataMsg.upgradeFileInfo.size()) {
            DCDebugTracer.trace(1, "AsnCoder", "decode()", "None refresh data");
            return;
        }
        AsnUpgradeFileInfoList asnUpgradeFileInfoList = AsnDataMsg.upgradeFileInfo;
        int size = AsnDataMsg.upgradeFileInfo.size();
        Object[][] updateData = new Object[size][4];
        AsnGetStructUpgradeFileTbl asnOneUpgradeFileTbl = null;
        for (int index = 0; index < size; ++index) {
            asnOneUpgradeFileTbl = (AsnGetStructUpgradeFileTbl)asnUpgradeFileInfoList.get(index);
            if (null == asnOneUpgradeFileTbl) {
                DCDebugTracer.trace(1, "AsnCoder", "decode()", "there is a recore is null");
                continue;
            }
            int curFile = asnOneUpgradeFileTbl.sysFileCurrent.intValue();
            int nextFile = asnOneUpgradeFileTbl.sysFileNext.intValue();
            this.initGUI(curFile, nextFile);
            Object[] currRow = new Object[]{this.getStringValue(asnOneUpgradeFileTbl.sysFileName), this.getStringValue(asnOneUpgradeFileTbl.sysFileLocation), new VisualData(asnOneUpgradeFileTbl.sysFileSize, asnOneUpgradeFileTbl.sysFileSize.toString()), this.getStringValue(asnOneUpgradeFileTbl.sysFileVersion), this.getYesOrNoValue(curFile), this.getYesOrNoValue(nextFile)};
            updateData[index] = currRow;
        }
        this.tblModel.getDataVector().clear();
        this.tblModel.addRows(updateData);
        DCDebugTracer.trace(3, "CommHandleMgr", "", "Exit DevMapProgramPanel.refreshData()");
    }

    private String getYesOrNoValue(int param) {
        if (1 == param) {
            return this.m_oYes;
        }
        if (0 == param) {
            return this.m_oNo;
        }
        return "";
    }

    private void updateCusUI(final JPanel parent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                parent.updateUI();
            }
        });
    }

    private MouseAdapter generateMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DevMapProgramPanel.this.triggerPopupMenu(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DevMapProgramPanel.this.triggerPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DevMapProgramPanel.this.triggerPopupMenu(e);
            }
        };
    }

    private void triggerPopupMenu(MouseEvent oMouseEvent) {
        int iClickedRow = this.table.rowAtPoint(oMouseEvent.getPoint());
        int[] nRows = this.table.getSelectedRows();
        if (nRows.length > 1) {
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setSelectionInterval(iClickedRow, iClickedRow);
        if (oMouseEvent.isPopupTrigger()) {
            this.initMenu();
            this.showPopUpMenu(oMouseEvent.getX(), oMouseEvent.getY());
        }
    }

    private void initMenu() {
        this.m_oPopupMenu = new JPopupMenu();
        JMenuItem topoMenuItem = new JMenuItem();
        JMenuItem backupMenuItem = new JMenuItem();
        JMenuItem deleteMenuItem = new JMenuItem();
        topoMenuItem.setText("");
        backupMenuItem.setText(this.oCustomResManager.getResString("DEVICETABLE_POPUP_MENU_ITEM_BACKUP"));
        deleteMenuItem.setText(this.oCustomResManager.getResString("DEVICETABLE_POPUP_MENU_ITEM_DELETE"));
        topoMenuItem.setVisible(false);
        this.m_oPopupMenu.add(topoMenuItem);
        this.m_oPopupMenu.add(backupMenuItem);
        this.m_oPopupMenu.add(deleteMenuItem);
        boolean bMenuShouldShow = this.isbackupMenuItemEnable();
        backupMenuItem.setEnabled(bMenuShouldShow && this.backupImageFilesPrivilege);
        deleteMenuItem.setEnabled(bMenuShouldShow && this.deleteImageFilesPrivilege && (!this.bIsSecurityDev || this.bIsSRGDev));
        backupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevMapProgramPanel.this.backupImageProgram();
            }
        });
        deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevMapProgramPanel.this.deleteActionPerformed();
            }
        });
    }

    public void deleteActionPerformed() {
        DCDebugTracer.trace(1, this.getClass().getName(), "deleteActionPerformed ", "Entering deleteActionPerformed");
        int[] rows = this.table.getSelectedRows();
        String l_fileNameValue = "";
        String l_fileLocationValue = "";
        for (int i = 0; i < rows.length; ++i) {
            l_fileNameValue = this.table.getModel().getValueAt(rows[i], 0).toString();
            l_fileLocationValue = this.table.getModel().getValueAt(rows[i], 1).toString();
        }
        AsnCustomOpPara l_imageName = new AsnCustomOpPara();
        l_imageName.strParaID = IMAGENAME_PARAID.getBytes();
        l_imageName.strParameterValue = l_fileNameValue.getBytes();
        AsnCustomOpPara l_imageLocation = new AsnCustomOpPara();
        l_imageLocation.strParaID = IMAGELOCATION_PARAID.getBytes();
        l_imageLocation.strParameterValue = l_fileLocationValue.getBytes();
        AsnCustomOpParaLst l_customParaList = new AsnCustomOpParaLst();
        l_customParaList.add((Object)l_imageName);
        l_customParaList.add((Object)l_imageLocation);
        AsnTaskResource l_taskRes = new AsnTaskResource();
        this.devcieInfo = this.deviceInfos[0];
        l_taskRes.iDeviceId = BigInteger.valueOf(this.devcieInfo.getDevID());
        AsnCustomOpInfo l_cusInfo = new AsnCustomOpInfo();
        l_cusInfo.oCustomOpParaLst = l_customParaList;
        l_cusInfo.oTaskResource = l_taskRes;
        AsnCustomOpInfoLst l_customOpList = new AsnCustomOpInfoLst();
        l_customOpList.add((Object)l_cusInfo);
        final AsnCustomOpReq l_customReq = new AsnCustomOpReq();
        l_customReq.oCustomOpInfoLst = l_customOpList;
        l_customReq.iUserId = BigInteger.valueOf(DCFrameWorkUtil.getUserId());
        l_customReq.strOperationId = DELETE_IMAGE.getBytes();
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.oCustomResManager.getResString("DELETECONFIRMINFO"), this.oCustomResManager.getResString("DELETE_IMAGE_DIALOG_TITLE"), 0);
        if (iConfirm != 0) {
            DCDebugTracer.trace(1, this.getClass().getName(), "deleteActionPerformed ", "Exiting deleteActionPerformed");
            return;
        }
        final AsnCustomOpRsp oAsnCustomOpRsp = new AsnCustomOpRsp();
        int iErrorCode = -1;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DevMapProgramPanel.this.m_oCommManager;
                DevMapProgramPanel.this.m_oCommManager;
                int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43941, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)l_customReq, (FStruct)oAsnCustomOpRsp);
                return errorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            iErrorCode = (Integer)syncCommand.getResult();
            if (0 != iErrorCode) {
                DCOptionPane.showWarningDialog(DCFrameWorkUtil.getMainFrame(), this.oCustomResManager.getResString("DELETEFAILED"));
            }
            iErrorCode = oAsnCustomOpRsp.oErrorInfo.iErrorNo.intValue();
        } else {
            iErrorCode = 103;
        }
        DCDebugTracer.trace(1, this.getClass().getName(), "deleteActionPerformed ", "Exiting deleteActionPerformed");
    }

    private boolean isbackupMenuItemEnable() {
        this.devcieInfo = this.deviceInfos[0];
        BusyDeviceObjectStore oBusyDeviceStore = BusyDeviceObjectStore.getInstance();
        return !oBusyDeviceStore.isDeviceOperationInProgress(this.devcieInfo.getDevID());
    }

    protected void showPopUpMenu(int x, int y) {
        this.m_oPopupMenu.show((Component)this.table, x, y);
    }

    private void backupImageProgram() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BackupdDlg m_oBackupdDlg = new BackupdDlg();
                m_oBackupdDlg.setVisible(true);
                TaskCommUtil.setSamFileImportShow(0);
            }
        });
    }

    class BackupdDlg
    extends SAMFileInfoImportDlg {
        private static final long serialVersionUID = -1776523411764067824L;
        SAMFileInfoImportPanel o_mBackupdPanel = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        String filePath = "";
        ContentType oContentType = null;
        private static final int IMAGE_FILE_TYPE = 1;
        private Color originFieldBGColor = null;

        public BackupdDlg() {
            DCDebugTracer.trace("DevMapProgramPanel#BackupdDlg Enter");
            TaskCommUtil.setSamFileImportShow(0);
            this.setCancelButtonClicked(false);
            this.setTitle(DevMapProgramPanel.this.oCustomResManager.getResString("BACKUP_PROGRAM"));
            this.setOkButtonEnable(true);
            this.setApplyButtonEnable(false);
            this.initializeTextFields();
            this.getSAMFileTreePanel().setCallType(1);
            this.getSAMFileTreePanel().setDevTypeForSaveBackupFile(this.oDeviceTypeInfo);
            this.initTreeSelection();
            this.getPanel().setVersionComponnetState(true);
            DCHelpManager.getInstance().enableHelpKey(this.getContentPane(), ResourceManager.getInstance().getResString("HELP_TOPIC_BACKUP_REFLECTION", "helpmapfile"));
            this.disableCompent();
        }

        private void disableCompent() {
            if (null != this.o_mBackupdPanel) {
                this.o_mBackupdPanel.disableFilePath(this.filePath);
                this.o_mBackupdPanel.disableContentType();
                this.o_mBackupdPanel.disableDeviceType();
            }
        }

        private void initTreeSelection() {
            this.getSAMFileTreePanel().setNodeState(this.oDeviceTypeInfo, true);
        }

        private void initializeTextFields() {
            DevMapProgramPanel.this.devcieInfo = DevMapProgramPanel.this.deviceInfos[0];
            this.o_mBackupdPanel = this.getPanel();
            this.oDeviceTypeInfo = DeviceInfoManagerImpl.getInstance().getDevice(DevMapProgramPanel.this.devcieInfo.getDevID()).getDeviceTypeInfo();
            this.o_mBackupdPanel.getDeviceTypeComboBox().getModel().setSelectedItem(this.oDeviceTypeInfo);
            ArrayList<DeviceTypeInfo> oDevTypeInfoList = new ArrayList<DeviceTypeInfo>();
            oDevTypeInfoList.add(this.oDeviceTypeInfo);
            this.o_mBackupdPanel.setDeviceTypeList(oDevTypeInfoList);
            ComboBoxWithToolTip o_mContentTypeComboBox = this.o_mBackupdPanel.getContentTypeComboBox();
            this.o_mBackupdPanel.fillContentTypeComboBox();
            int oCount = o_mContentTypeComboBox.getItemCount();
            this.o_mBackupdPanel.setFromBackImageDlg(true);
            for (int i = 0; i < oCount; ++i) {
                this.oContentType = (ContentType)o_mContentTypeComboBox.getSelectedItem();
                if (!DevMapProgramPanel.PROGRAMID.equals(this.oContentType.getId())) continue;
                o_mContentTypeComboBox.setSelectedItem(this.oContentType);
                break;
            }
            this.o_mBackupdPanel.disableContentType();
            this.o_mBackupdPanel.disableDeviceType();
            int selectedRow = DevMapProgramPanel.this.table.getSelectedRow();
            String fileName = DevMapProgramPanel.this.table.getModel().getValueAt(selectedRow, 0).toString();
            String dir = DevMapProgramPanel.this.table.getModel().getValueAt(selectedRow, 1).toString();
            this.filePath = dir + fileName;
            this.o_mBackupdPanel.disableFilePath(this.filePath);
            String fileVersion = DevMapProgramPanel.this.table.getModel().getValueAt(selectedRow, 3).toString().trim();
            this.o_mBackupdPanel.m_oDevVersionTextField.setText(fileVersion);
            this.o_mBackupdPanel.setFromBackImageDlg(false);
            this.originFieldBGColor = this.o_mBackupdPanel.getBackground();
            this.o_mBackupdPanel.m_oDescriptionTextArea.setBackground(this.originFieldBGColor);
            this.o_mBackupdPanel.m_oDescriptionTextArea.setEditable(false);
        }

        @Override
        public void okBtnActionPerformed() {
            String m_oDevVersionText = this.o_mBackupdPanel.m_oDevVersionTextField.getText().toUpperCase();
            String m_oDescriptionText = this.o_mBackupdPanel.m_oDescriptionTextArea.getText().toUpperCase();
            if (0 == m_oDevVersionText.trim().length()) {
                DCOptionPane.showMessageDialog((Component)((Object)this), DevMapProgramPanel.this.oCustomResManager.getResString("SAM_ERROR_BLANK_VERSION"));
                return;
            }
            if (2 == this.oDeviceTypeInfo.getDevDomain() && this.o_mBackupdPanel.m_oDevVersionTextField.getText().trim().contains(" ")) {
                DCOptionPane.showMessageDialog((Component)((Object)this), DevMapProgramPanel.this.oCustomResManager.getResString("SAM_ERROR_VERSION_CONTAIN_SPACE"));
                return;
            }
            if (!SAMFileInfoImportPanelHelper.isNameValid(this.o_mBackupdPanel.m_oDevVersionTextField.getText().trim())) {
                DCOptionPane.showMessageDialog((Component)((Object)this), DevMapProgramPanel.this.oCustomResManager.getResString("INVALID_CHAR_IN_VERSION"));
                return;
            }
            if (!SAMFileInfoImportPanelHelper.isNameValid(this.o_mBackupdPanel.m_oDevPatchVersionTextField.getText().trim())) {
                DCOptionPane.showMessageDialog((Component)((Object)this), DevMapProgramPanel.this.oCustomResManager.getResString("INVALID_CHAR_IN_PatchVersion"));
                return;
            }
            if (!SAMFileInfoImportPanelHelper.isNameValid(this.o_mBackupdPanel.m_oDescriptionTextArea.getText().trim())) {
                DCOptionPane.showMessageDialog((Component)((Object)this), DevMapProgramPanel.this.oCustomResManager.getResString("INVALID_CHAR_IN_DESCRIPTION"));
                return;
            }
            this.setVisible(false);
            AsnDCBackupAndSAMReq oAsnDCBackupAndSAMReq = new AsnDCBackupAndSAMReq();
            int userID = DCFrameWorkUtil.getSecurityManager().getUserId();
            oAsnDCBackupAndSAMReq.iUserId = BigInteger.valueOf(userID);
            AsnDCCustomBackupInfo oAsnDCCustomBackupInfo = new AsnDCCustomBackupInfo();
            oAsnDCCustomBackupInfo.iDeviceID = BigInteger.valueOf(DevMapProgramPanel.this.devcieInfo.getDevID());
            List<DeviceTypeInfo> oDevTypeList = this.getSAMFileTreePanel().getSelectedDeviceTypeList();
            DeviceTypeInfo oDevTypeInfo = null;
            int iDevTypeSize = oDevTypeList.size();
            for (int i = 0; i < iDevTypeSize; ++i) {
                oDevTypeInfo = oDevTypeList.get(i);
                AsnDevTypeIdInfo oAsnDevTypeIdInfo = new AsnDevTypeIdInfo();
                oAsnDevTypeIdInfo.iDevTypeId = BigInteger.valueOf(oDevTypeInfo.getDevTypeID());
                oAsnDevTypeIdInfo.iDevTypeVerId = BigInteger.valueOf(oDevTypeInfo.getDevTypeVersionId());
                oAsnDCCustomBackupInfo.oSAMImportFileInfo.oDevTypeIdInfoList.add((Object)oAsnDevTypeIdInfo);
            }
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strFileName = this.filePath.getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strDescription = m_oDescriptionText.trim().getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strVersion = m_oDevVersionText.trim().getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strBDVersion = "".getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oSAMT2000FileLst = new AsnSAMT2000FileLst();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.iFileType = null != this.oContentType ? BigInteger.valueOf(this.oContentType.getContentTypeCode()) : new BigInteger("1");
            int selectedRow = DevMapProgramPanel.this.table.getSelectedRow();
            Object oSize = DevMapProgramPanel.this.table.getModel().getValueAt(selectedRow, 2);
            String sizeStr = "";
            sizeStr = oSize instanceof VisualData ? ((VisualData)oSize).value.toString() : DevMapProgramPanel.this.table.getModel().getValueAt(selectedRow, 2).toString();
            sizeStr = String.valueOf(sizeStr);
            int iImportMode = 0;
            AsnImportModeEnum oAsnImportModeEnum = new AsnImportModeEnum();
            oAsnImportModeEnum.value = iImportMode;
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.enImportMode = oAsnImportModeEnum;
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strSize = sizeStr.getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.bOverWrite = false;
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.bIsClientFile = false;
            oAsnDCCustomBackupInfo.oSAMImportFileInfo._bIsClientFile = false;
            String strBasePath = this.filePath;
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.strBasePath = strBasePath.getBytes();
            oAsnDCCustomBackupInfo.oSAMImportFileInfo.oFileInfo.strBDVersion = "".getBytes();
            oAsnDCBackupAndSAMReq.oCustomBackupInfoLst.add((Object)oAsnDCCustomBackupInfo);
            int iErrCode = this.backupImageProgram(oAsnDCBackupAndSAMReq);
            if (989855899 == iErrCode) {
                int iConfirm = -1;
                iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAM_OVERWRITE_CONFIRNMATION_MESSAGE"), ResourceManager.getInstance().getResString("CONFIRMATION_DIALOG_TITLE"), 0);
                if (iConfirm != 0) {
                    return;
                }
                oAsnDCCustomBackupInfo.oSAMImportFileInfo.bOverWrite = true;
                iErrCode = this.backupImageProgram(oAsnDCBackupAndSAMReq);
            }
            if (0 != iErrCode) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode)), DevMapProgramPanel.this.oCustomResManager.getResString("ERROR"), 0);
            }
            this.dispose();
        }

        private int backupImageProgram(final AsnDCBackupAndSAMReq oAsnDCBackupAndSAMReq) {
            int iErrorCode = -1;
            final AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
            SyncCommand syncCommand = new SyncCommand(){

                public Object call() throws Exception {
                    BaseCommManager baseCommManager = DevMapProgramPanel.this.m_oCommManager;
                    DevMapProgramPanel.this.m_oCommManager;
                    int errorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43986), (FStruct)oAsnDCBackupAndSAMReq, (FStruct)oAsnDCOpertionRsp);
                    return errorCode;
                }
            };
            syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
            if (syncCommand.getResult() != null) {
                iErrorCode = (Integer)syncCommand.getResult();
                if (0 != iErrorCode) {
                    return iErrorCode;
                }
                iErrorCode = oAsnDCOpertionRsp.oErrorInfo.iErrorNo.intValue();
            } else {
                iErrorCode = 103;
            }
            return iErrorCode;
        }
    }
}

