/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cmf.dc.customoperation.constant;

import com.huawei.cmf.dc.customoperation.asn1.AsnGetSpaceInfoMsg;
import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileMsg;
import com.huawei.cmf.dc.customoperation.asn1.AsnGetStructUpgradeFileTbl;
import com.huawei.cmf.dc.customoperation.asn1.AsnUpgradeFileInfoList;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.FStruDecoderFixUTC;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.ICustomOperationResult;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IDeviceInfo;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import gnu.trove.THashMap;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class CustomerInfoManager
implements IDeviceConfigChangeListener,
ICustomOperationResult {
    private static CustomerInfoManager m_oCustomerMgr = null;
    private THashMap<Integer, AsnGetStructUpgradeFileMsg> m_oDevMapHm = new THashMap();
    private THashMap<Integer, AsnGetSpaceInfoMsg> m_oDiskSizeHm = new THashMap();
    private THashMap<Integer, AsnGetStructUpgradeFileMsg> m_oLicenceHm = new THashMap();
    private THashMap<Integer, AsnGetStructUpgradeFileMsg> m_oConfigHm = new THashMap();
    private THashMap<Integer, AsnGetStructUpgradeFileMsg> m_oPafHm = new THashMap();

    public static synchronized CustomerInfoManager getInstance() {
        if (null == m_oCustomerMgr) {
            m_oCustomerMgr = new CustomerInfoManager();
        }
        return m_oCustomerMgr;
    }

    private CustomerInfoManager() {
        this.registerForServerNotifications();
    }

    private void registerForServerNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
    }

    public void addCustomerInfo(int iOperationID, int iDevID, FStruct oCustomerInfo) {
        if (null == oCustomerInfo) {
            return;
        }
        if (iOperationID == 1) {
            if (!(oCustomerInfo instanceof AsnGetSpaceInfoMsg)) {
                return;
            }
            this.addDiskInfo(iDevID, (AsnGetSpaceInfoMsg)oCustomerInfo);
            return;
        }
        if (!(oCustomerInfo instanceof AsnGetStructUpgradeFileMsg)) {
            return;
        }
        THashMap oDataHm = this.getDataHm(iOperationID);
        if (null == oDataHm) {
            oDataHm = new THashMap();
        }
        if (oDataHm.containsKey((Object)iDevID)) {
            oDataHm.remove((Object)iDevID);
        }
        oDataHm.put((Object)iDevID, (Object)((AsnGetStructUpgradeFileMsg)oCustomerInfo));
    }

    public AsnGetStructUpgradeFileMsg getDevMapInfo(int iDevID) {
        if (null == this.m_oDevMapHm) {
            return null;
        }
        return (AsnGetStructUpgradeFileMsg)this.m_oDevMapHm.get((Object)iDevID);
    }

    private void addDiskInfo(int iDevID, AsnGetSpaceInfoMsg oAsnGetSpaceInfoMsg) {
        if (null == oAsnGetSpaceInfoMsg) {
            return;
        }
        if (null == this.m_oDiskSizeHm) {
            this.m_oDiskSizeHm = new THashMap();
        }
        if (this.m_oDiskSizeHm.containsKey((Object)iDevID)) {
            this.m_oDiskSizeHm.remove((Object)iDevID);
        }
        this.m_oDiskSizeHm.put((Object)iDevID, (Object)oAsnGetSpaceInfoMsg);
    }

    public AsnGetSpaceInfoMsg getDiskInfo(int iDevID) {
        if (null == this.m_oDiskSizeHm) {
            return null;
        }
        return (AsnGetSpaceInfoMsg)this.m_oDiskSizeHm.get((Object)iDevID);
    }

    public AsnGetStructUpgradeFileMsg getLicenceInfo(int iDevID) {
        if (null == this.m_oLicenceHm) {
            return null;
        }
        return (AsnGetStructUpgradeFileMsg)this.m_oLicenceHm.get((Object)iDevID);
    }

    public AsnGetStructUpgradeFileMsg getConfigInfo(int iDevID) {
        if (null == this.m_oConfigHm) {
            return null;
        }
        return (AsnGetStructUpgradeFileMsg)this.m_oConfigHm.get((Object)iDevID);
    }

    public AsnGetStructUpgradeFileMsg getPafInfo(int iDevID) {
        if (null == this.m_oPafHm) {
            return null;
        }
        return (AsnGetStructUpgradeFileMsg)this.m_oPafHm.get((Object)iDevID);
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        switch (iEventType) {
            case 1: {
                this.handleDeviceDeleteNotification(oDeviceInfoList);
                break;
            }
        }
    }

    private synchronized void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        DeviceInfo deviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        int iDevID = -1;
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            deviceInfo = oDevMgr.getDeviceFromAsn(oAsnDeviceInfo.oDeviceInfo);
            if (null == deviceInfo) continue;
            iDevID = deviceInfo.getDevId();
            this.removeDeviceFromHm(iDevID);
        }
    }

    private void removeDeviceFromHm(int iDevID) {
        if (null != this.m_oDevMapHm) {
            this.m_oDevMapHm.remove((Object)iDevID);
        }
        if (null != this.m_oDiskSizeHm) {
            this.m_oDiskSizeHm.remove((Object)iDevID);
        }
        if (null != this.m_oLicenceHm) {
            this.m_oLicenceHm.remove((Object)iDevID);
        }
        if (null != this.m_oConfigHm) {
            this.m_oConfigHm.remove((Object)iDevID);
        }
        if (null != this.m_oPafHm) {
            this.m_oPafHm.remove((Object)iDevID);
        }
    }

    public void removeFileInfo(int iOperationID, int iDevID, List<Object> oDataLst) {
        if (null == oDataLst) {
            return;
        }
        THashMap<Integer, AsnGetStructUpgradeFileMsg> oDataHm = this.getDataHm(iOperationID);
        if (null == oDataHm) {
            return;
        }
        AsnGetStructUpgradeFileMsg oData = (AsnGetStructUpgradeFileMsg)oDataHm.get((Object)iDevID);
        if (null == oData) {
            return;
        }
        AsnUpgradeFileInfoList oFileLst = oData.upgradeFileInfo;
        Iterator oFileItor = oFileLst.iterator();
        AsnGetStructUpgradeFileTbl oFile = null;
        String sFileName = "";
        String sFilePath = "";
        Collator oCol = Collator.getInstance();
        block0: while (oFileItor.hasNext()) {
            oFile = (AsnGetStructUpgradeFileTbl)oFileItor.next();
            sFileName = new String(oFile.sysFileName);
            sFilePath = new String(oFile.sysFileLocation);
            if (oDataLst.size() == 0) break;
            for (int j = 0; j < oDataLst.size(); ++j) {
                Vector oDelFile = (Vector)oDataLst.get(j);
                String sDelFileName = (String)oDelFile.get(0);
                String sDelFilePath = (String)oDelFile.get(1);
                if (!oCol.equals(sFileName, sDelFileName) || !oCol.equals(sFilePath, sDelFilePath)) continue;
                oFileItor.remove();
                oDataLst.remove(j);
                continue block0;
            }
        }
    }

    private THashMap<Integer, AsnGetStructUpgradeFileMsg> getDataHm(int iOperationID) {
        switch (iOperationID) {
            case 0: {
                return this.m_oDevMapHm;
            }
            case 1: {
                return null;
            }
            case 2: {
                return this.m_oLicenceHm;
            }
            case 3: {
                return this.m_oPafHm;
            }
            case 4: {
                return this.m_oConfigHm;
            }
        }
        return null;
    }

    @Override
    public void notifyMessage(ICustomOperationEvent event) {
        if ("DeleteImage".equals(event.getOperationID())) {
            AsnGetStructUpgradeFileMsg asnGetStructUpgradeFileMsg = new AsnGetStructUpgradeFileMsg();
            byte[] msgResult = null;
            IDeviceInfo[] deviceInfos = event.getDeviceInfo();
            msgResult = event.getResult();
            if (event.getiFailureReason() != -1) {
                return;
            }
            if (msgResult != null && msgResult.length != 0) {
                FStruDecoderFixUTC deccoder = new FStruDecoderFixUTC(msgResult);
                try {
                    asnGetStructUpgradeFileMsg.deserialize((Decoder)deccoder);
                    if (0 == asnGetStructUpgradeFileMsg.errorCode.intValue()) {
                        AsnUpgradeFileInfoList oFileInfoLst = asnGetStructUpgradeFileMsg.upgradeFileInfo;
                        ArrayList<Object> oDataLst = new ArrayList<Object>();
                        for (int i = 0; i < oFileInfoLst.size(); ++i) {
                            AsnGetStructUpgradeFileTbl oFileInfo = (AsnGetStructUpgradeFileTbl)oFileInfoLst.get(i);
                            Vector<String> oFileInfoVec = new Vector<String>();
                            oFileInfoVec.add(new String(oFileInfo.sysFileName));
                            oFileInfoVec.add(new String(oFileInfo.sysFileLocation));
                            oDataLst.add(oFileInfoVec);
                        }
                        int iDevID = deviceInfos[0].getDevID();
                        this.removeFileInfo(0, iDevID, oDataLst);
                    }
                }
                catch (FStruException e) {
                    DCDebugTracer.trace("AsnCoder #decode()===> decode failed");
                    DCDebugTracer.trace((Exception)((Object)e));
                }
            }
        }
    }
}

