/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cmf.dc.customoperation.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FormatedOutputStream;

public class AsnGetSpaceInfoTbl
implements FStruct {
    public BigInteger totalSpace;
    public BigInteger spaceFree;
    public byte[] storageType;
    public byte[] storageName;

    public AsnGetSpaceInfoTbl() {
    }

    public AsnGetSpaceInfoTbl(AsnGetSpaceInfoTbl arg) {
        this.totalSpace = arg.totalSpace;
        this.spaceFree = arg.spaceFree;
        this.storageType = new byte[arg.storageType.length];
        System.arraycopy(arg.storageType, 0, this.storageType, 0, arg.storageType.length);
        this.storageName = new byte[arg.storageName.length];
        System.arraycopy(arg.storageName, 0, this.storageName, 0, arg.storageName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.totalSpace);
        enc.serializeInteger(this.spaceFree);
        enc.serializeOctetString(this.storageType);
        enc.serializeOctetString(this.storageName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.totalSpace = dec.deserializeInteger();
        this.spaceFree = dec.deserializeInteger();
        this.storageType = dec.deserializeOctetString();
        this.storageName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("totalSpace = ");
        os.print(this.totalSpace.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("spaceFree = ");
        os.print(this.spaceFree.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("storageType = ");
        try {
            new FormatedOutputStream((OutputStream)os).write(this.storageType);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("storageName = ");
        try {
            new FormatedOutputStream((OutputStream)os).write(this.storageName);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println();
        for (int ii3 = 0; ii3 < indent; ++ii3) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }
}

