/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import com.swimap.imap.common.util.log.AbstractLogger;
import com.swimap.imap.common.util.log.ArchiveFileHandler;
import com.swimap.imap.common.util.log.ImapFormatter;
import com.swimap.imap.common.util.log.LogConfig;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerImpl
extends AbstractLogger {
    static final Level[] levels = new Level[]{Level.ALL, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE};
    private Logger logger = null;

    protected LoggerImpl(LogConfig config) {
        this.config = config;
        ArchiveFileHandler handler = null;
        try {
            File dir = new File(config.path);
            if (!dir.exists()) {
                dir.mkdir();
            }
            handler = new ArchiveFileHandler(config.path, config.fileprefix, config.size, config.count);
            handler.setFormatter(new ImapFormatter(config.invoker));
            this.logger = Logger.getLogger(config.name);
            this.logger.addHandler(handler);
            this.logger.setUseParentHandlers(false);
            this.setLevel(config.level);
            this.log(6, "java.util.logging impl for ImapLogger loaded");
        }
        catch (Throwable t) {
            this.enabled = false;
            System.err.println(t.getMessage());
        }
    }

    @Override
    protected void logImpl(int level, Object msg) {
        this.logger.log(levels[level], msg.toString());
    }

    @Override
    protected void logImpl(int level, Object msg, Throwable thrown) {
        this.logger.log(levels[level], msg.toString(), thrown);
    }

    @Override
    protected void setLevelImpl(int level) {
        this.logger.setLevel(levels[level]);
    }

    @Override
    protected boolean isLoggableImpl(int level) {
        return this.logger.isLoggable(levels[level]);
    }
}

