/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import com.swimap.imap.common.util.log.ImapLogger;
import com.swimap.imap.common.util.log.LogConfig;
import com.swimap.imap.common.util.log.LoggerImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LogFactory {
    private static LogFactory instance = null;
    private Map loggers = new HashMap();

    private LogFactory() {
    }

    public static synchronized LogFactory getInstance() {
        if (instance == null) {
            instance = new LogFactory();
        }
        return instance;
    }

    public ImapLogger getLogger(LogConfig config) {
        LoggerImpl logger = new LoggerImpl(config);
        this.loggers.put(logger, config);
        return logger;
    }

    public int getLevel(String levelname) {
        int level = 3;
        for (int i = 0; i < LoggerImpl.levels.length; ++i) {
            if (!LoggerImpl.levelnames[i].equals(levelname)) continue;
            level = i;
            break;
        }
        return level;
    }

    public void reloadLevel() {
        Iterator it = this.loggers.keySet().iterator();
        while (it.hasNext()) {
            try {
                ImapLogger logger = (ImapLogger)it.next();
                LogConfig config = (LogConfig)this.loggers.get(logger);
                config.reloadLevel();
                logger.setLevel(config.level);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

