/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogArchiver {
    private static final long DeadFileInterval = 60000L;

    public static void archiveFiles(File[] files, String zipFile) throws IOException {
        if (files != null) {
            LogArchiver.archiveFiles(files, zipFile, 0, files.length - 1);
        }
    }

    public static void archiveFiles(File[] files, String zipFile, int begin, int end) throws IOException {
        if (files == null || files.length == 0) {
            return;
        }
        boolean isAllEmpty = true;
        for (int i = begin; i <= end; ++i) {
            if (files[i] == null || !files[i].exists()) continue;
            if (files[i].length() > 0L) {
                isAllEmpty = false;
                continue;
            }
            try {
                files[i].delete();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isAllEmpty) {
            return;
        }
        FileOutputStream fo = null;
        ZipOutputStream zo = null;
        try {
            fo = new FileOutputStream(zipFile);
            zo = new ZipOutputStream(fo);
            for (int i = begin; i <= end; ++i) {
                if (files[i] == null || !files[i].exists()) continue;
                try {
                    if (System.currentTimeMillis() - files[i].lastModified() < 60000L) continue;
                    if (files[i].length() > 0L) {
                        ZipEntry ze = new ZipEntry(files[i].getName());
                        ze.setTime(files[i].lastModified());
                        zo.putNextEntry(ze);
                        LogArchiver.zipFile(zo, files[i]);
                    }
                    files[i].delete();
                    continue;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (zo != null) {
                try {
                    zo.close();
                }
                catch (Exception e2) {}
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (Exception e2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long zipFile(OutputStream zo, File file) throws IOException {
        byte[] buff = new byte[1024];
        long size = 0L;
        FileInputStream in = null;
        BufferedInputStream bin = null;
        try {
            in = new FileInputStream(file);
            bin = new BufferedInputStream(in);
            int len = 0;
            while (len >= 0) {
                len = bin.read(buff);
                if (len == -1) continue;
                zo.write(buff, 0, len);
                size += (long)len;
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException ioException) {}
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioException) {}
            }
        }
        return size;
    }
}

