/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class ImapFormatter
extends Formatter {
    private static final IviewLogger logger = IviewLogger.getLogger(ImapFormatter.class, (String)"TM");
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private static final String fieldSeparator = " | ";
    private String LoggerClassName = null;
    private static MessageFormat formatter;
    private Object[] args = new Object[1];
    private String SourceClassName = null;
    private String SourceMethodName = null;
    private int LineNumber;
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public ImapFormatter(String invoker) {
        this.LoggerClassName = invoker;
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        StringBuffer text = new StringBuffer();
        if (formatter == null) {
            formatter = new MessageFormat(format);
        }
        formatter.format(this.args, text, (FieldPosition)null);
        sb.append("[");
        sb.append(Thread.currentThread().getName());
        sb.append("]");
        sb.append(fieldSeparator);
        sb.append(text);
        sb.append(fieldSeparator);
        this.inferCaller();
        if (this.SourceClassName != null) {
            sb.append(this.SourceClassName);
        } else {
            sb.append(record.getLoggerName());
        }
        if (this.SourceMethodName != null) {
            sb.append(fieldSeparator);
            sb.append(this.SourceMethodName);
            sb.append(":");
            sb.append(this.LineNumber);
            sb.append(fieldSeparator);
        }
        String message = this.formatMessage(record);
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
        return sb.toString();
    }

    public static void resetFormatter() {
        formatter = new MessageFormat(format);
        DebugTracer.trace((String)"Reset the client logger timezone.");
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        this.SourceClassName = null;
        this.SourceMethodName = null;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(this.LoggerClassName); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(this.LoggerClassName)) {
                this.SourceClassName = cname;
                this.SourceMethodName = frame.getMethodName();
                this.LineNumber = frame.getLineNumber();
                return;
            }
            ++ix;
        }
    }
}

