/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import com.swimap.imap.common.util.log.LogArchiver;
import com.swimap.iview.util.log.IviewLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class ArchiveFileHandler
extends StreamHandler {
    private static final IviewLogger logger = IviewLogger.getLogger(ArchiveFileHandler.class, (String)"TM");
    private static final String FilePattern = "{0,date,yyyy_MM_dd}_{0,time,HH_mm_ss}";
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private File[] files;
    private String logpath;
    private String namePreFix;

    public ArchiveFileHandler(String path, String namePreFix, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.logpath = path;
        this.limit = limit;
        this.count = count;
        this.namePreFix = namePreFix;
        StringBuffer sPath = new StringBuffer(path);
        sPath.append("/");
        sPath.append(namePreFix);
        sPath.append(MessageFormat.format(FilePattern, new Date()));
        this.pattern = sPath.toString();
        this.append = false;
        this.openFiles();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ArchiveFileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        super.close();
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = FileHandler.class.getName();
        String sLevel = manager.getProperty(cname + ".level");
        Level level = Level.ALL;
        try {
            level = Level.parse(sLevel.trim());
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        this.setLevel(level);
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    private void openFiles() throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.checkAccess();
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        this.files = new File[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.files[i] = this.generate(this.pattern, i, 0);
        }
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        Exception ex = em.lastException;
        this.handleException(ex);
        this.setErrorManager(new ErrorManager());
    }

    private void handleException(Exception ex) throws IOException {
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new IOException("Exception: " + ex);
        }
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (ArchiveFileHandler.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (this.count > 1 && !sawg) {
            word = word + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = word + "." + unique;
        }
        if ((word = word + ".txt").length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void doArchive() throws IOException {
        File[] aFiles = this.getBeArchivedFiles();
        if (aFiles != null) {
            LogArchiver.archiveFiles(aFiles, this.getNextArchiveName());
        }
    }

    private String getNextArchiveName() throws IOException {
        File[] aFiles;
        int archiveIndex = 0;
        File logDir = new File(this.logpath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isLogArchive = false;
                if (name != null) {
                    isLogArchive = name.indexOf(ArchiveFileHandler.this.namePreFix) > -1;
                    isLogArchive &= name.indexOf("zip") > -1;
                }
                return isLogArchive;
            }
        };
        File latest = null;
        if (logDir != null && logDir.exists() && (aFiles = logDir.listFiles(filter)) != null && aFiles.length >= 1) {
            latest = aFiles[0];
            for (int i = 0; i < aFiles.length; ++i) {
                if (latest.lastModified() >= aFiles[i].lastModified()) continue;
                latest = aFiles[i];
            }
        }
        if (latest != null) {
            try {
                String lastArchiveName = latest.getName();
                String sIndex = lastArchiveName.substring(this.namePreFix.length(), lastArchiveName.lastIndexOf(".zip"));
                archiveIndex = Integer.parseInt(sIndex) + 1;
                if (archiveIndex >= this.count) {
                    archiveIndex = 0;
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        StringBuffer sFileName = new StringBuffer(this.logpath);
        sFileName.append("/");
        sFileName.append(this.namePreFix);
        sFileName.append(archiveIndex);
        sFileName.append(".zip");
        return sFileName.toString();
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        try {
            this.doArchive();
        }
        catch (IOException ix) {
            this.reportError(null, ix, 0);
        }
        this.setLevel(Level.OFF);
        super.close();
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            }
            f1.renameTo(f2);
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    private File[] getBeArchivedFiles() throws IOException {
        File[] aFiles = null;
        File logDir = new File(this.logpath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean isLogFile = false;
                if (name != null) {
                    isLogFile = name.indexOf(ArchiveFileHandler.this.namePreFix) > -1;
                    isLogFile &= name.indexOf("zip") <= -1;
                }
                return isLogFile;
            }
        };
        if (logDir != null && logDir.exists() && ((aFiles = logDir.listFiles(filter)) == null || aFiles.length < this.count)) {
            aFiles = null;
        }
        return aFiles;
    }

    private static native boolean isSetUID();

    private class MeteredStream
    extends OutputStream {
        private OutputStream out;
        private int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }
}

