/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util.log;

import com.swimap.imap.common.util.log.ImapLogger;
import com.swimap.imap.common.util.log.LogConfig;
import com.swimap.iview.util.log.IviewLogger;

public abstract class AbstractLogger
implements ImapLogger {
    private static final IviewLogger logger = IviewLogger.getLogger(AbstractLogger.class, (String)"TM");
    static int FORCESTACKLEVEL = 5;
    protected static final String[] levelnames = new String[]{"ALL", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF"};
    protected LogConfig config = null;
    protected boolean enabled = true;

    @Override
    public final void log(int level, Object msg) {
        try {
            if (this.isLoggable(level)) {
                if (this.enabled) {
                    this.logImpl(level, this.getMsgString(msg));
                } else {
                    System.err.println(msg);
                }
            }
            if (level >= FORCESTACKLEVEL && level != 6) {
                this.logStack();
            }
        }
        catch (Throwable thrown) {
            System.err.println(thrown.getMessage());
            System.err.println(msg);
        }
    }

    @Override
    public final void log(int level, Object msg, Throwable thrown) {
        try {
            if (this.isLoggable(level)) {
                if (this.enabled) {
                    this.logImpl(level, this.getMsgString(msg), thrown);
                } else {
                    System.err.println(msg);
                }
            }
            if (level >= FORCESTACKLEVEL && level != 6) {
                this.logStack();
            }
        }
        catch (Throwable throow) {
            System.err.println(throow.getMessage());
            System.err.println(msg);
        }
    }

    @Override
    public final void setLevel(int level) {
        try {
            this.config.level = level;
            this.setLevelImpl(level);
            try {
                this.log(6, "Current Level:" + levelnames[level]);
            }
            catch (RuntimeException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (Throwable thrown) {
            System.err.println(thrown.getMessage());
        }
    }

    @Override
    public final boolean isLoggable(int level) {
        boolean logable = false;
        try {
            logable = this.isLoggableImpl(level);
        }
        catch (Throwable thrown) {
            System.err.println(thrown.getMessage());
            logable = this.config.level <= level;
        }
        return logable;
    }

    private void logStack() {
        try {
            this.log(6, "Automatic stack log:", this.genThrowable("stack info"));
        }
        catch (Throwable thrown) {
            System.err.println(thrown.getMessage());
            thrown.printStackTrace();
        }
    }

    private Throwable genThrowable(String msg) {
        int ix;
        Throwable thrown = new Throwable();
        StackTraceElement[] stack = thrown.getStackTrace();
        for (ix = 0; ix < stack.length; ++ix) {
            StackTraceElement frame = stack[ix];
            String cname = frame.getClassName();
            if (!cname.equals(this.config.invoker)) continue;
            break;
        }
        StackTraceElement[] newStack = new StackTraceElement[stack.length - ix];
        System.arraycopy(stack, ix, newStack, 0, stack.length - ix);
        thrown.setStackTrace(newStack);
        return thrown;
    }

    private String getMsgString(Object msg) {
        if (msg != null) {
            return msg.toString();
        }
        return "null msg";
    }

    protected abstract void logImpl(int var1, Object var2);

    protected abstract void logImpl(int var1, Object var2, Throwable var3);

    protected abstract boolean isLoggableImpl(int var1);

    protected abstract void setLevelImpl(int var1);
}

