/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util;

import com.swimap.external.common.adapter.message.util.CommonLogger;
import com.swimap.imap.common.util.EmfPropertyResBundle;
import com.swimap.imap.common.util.EmfResBundleInterface;
import com.swimap.imap.common.util.EmfXMLResBundle;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public abstract class EmfResBundle
implements EmfResBundleInterface {
    static final String COMMOMRESPREFIX = "{#";
    static final String COMMOMRESPOSTFIX = "#}";
    static final String EXTENDPOSTFIX = "_ext";
    protected Hashtable m_hashTable = new Hashtable();
    public static final int XMLFILE = 0;
    public static final int PROPERTIESFILE = 1;
    protected static final Locale m_locale = ResourceMng.getInstance().getLocale();
    protected static final String m_propertiesDir = "style/defaultstyle/locale/";
    protected static final String m_extPropertiesDir = "style/productstyle/locale/";
    protected static final String m_xmlDir = "style/defaultstyle/locale";
    protected static final String m_extXmlDir = "style/productstyle/locale";
    protected StringBuffer m_resourceDir = new StringBuffer();
    protected StringBuffer m_extResourceDir = new StringBuffer();
    public static final String XMLFILEEXT = ".xml";
    public static final String PROPERTIESFILEEXT = ".properties";
    protected StringBuffer m_fileExt = new StringBuffer();
    public static final String CUSTOMEXTFILE = "CUSTOM_EMFRESBUNDLE_EXT_FILE";

    public static EmfResBundle createResManager(String fileName, int fileType) {
        if (fileType == 0) {
            return new EmfXMLResBundle(fileName);
        }
        if (fileType == 1) {
            return new EmfPropertyResBundle(fileName);
        }
        return null;
    }

    public static EmfResBundle createResManager(int fileType) {
        if (fileType == 0) {
            return new EmfXMLResBundle();
        }
        if (fileType == 1) {
            return new EmfPropertyResBundle();
        }
        return null;
    }

    @Override
    public void loadFile(String fileName) {
        this.loadFileExt(fileName);
    }

    @Override
    public void clear() {
        this.m_hashTable.clear();
    }

    @Override
    public String getString(String skey) {
        if (skey == null) {
            return "";
        }
        String value = null;
        value = this.getStringExt(skey.trim());
        if (value == null) {
            return skey;
        }
        return value;
    }

    private String getStringExt(String skey) {
        String value = this.getProperty(skey);
        if (value == null) {
            return null;
        }
        if (value.indexOf(COMMOMRESPREFIX) == -1) {
            return value;
        }
        StringBuffer tokenValueBuffer = new StringBuffer(value);
        int prefixPos = 0;
        int posfixPos = 0;
        StringBuffer subToken = new StringBuffer();
        StringBuffer subTokenValue = new StringBuffer();
        int prefixLen = COMMOMRESPREFIX.length();
        int posfixLen = COMMOMRESPOSTFIX.length();
        int currentPos = 0;
        while ((prefixPos = tokenValueBuffer.indexOf(COMMOMRESPREFIX, currentPos)) != -1) {
            posfixPos = tokenValueBuffer.indexOf(COMMOMRESPOSTFIX, prefixPos + prefixLen);
            if (posfixPos == -1) {
                return null;
            }
            subToken.replace(0, subToken.length(), tokenValueBuffer.substring(prefixPos + prefixLen, posfixPos));
            if (this.getProperty(subToken.toString()) == null) {
                return null;
            }
            subTokenValue.replace(0, subTokenValue.length(), this.getProperty(subToken.toString()));
            currentPos = prefixPos + subTokenValue.length();
            tokenValueBuffer.replace(prefixPos, posfixPos + posfixLen, subTokenValue.toString());
        }
        this.setProperty(skey, tokenValueBuffer.toString());
        return tokenValueBuffer.toString();
    }

    @Override
    public String getString(String skey, String arg0) {
        String[] strs = new String[]{arg0};
        return this.getStringwithParameter(skey, strs);
    }

    @Override
    public String getString(String skey, String arg0, String arg1) {
        String[] strs = new String[]{arg0, arg1};
        return this.getStringwithParameter(skey, strs);
    }

    @Override
    public String getString(String skey, String arg0, String arg1, String arg2) {
        String[] strs = new String[]{arg0, arg1, arg2};
        return this.getStringwithParameter(skey, strs);
    }

    @Override
    public String getString(String skey, String arg0, String arg1, String arg2, String arg3) {
        String[] strs = new String[]{arg0, arg1, arg2, arg3};
        return this.getStringwithParameter(skey, strs);
    }

    private String getStringwithParameter(String skey, String[] strs) {
        StringBuffer result = null;
        try {
            result = new StringBuffer(MessageFormat.format(this.getString(skey), strs));
        }
        catch (Exception e) {
            CommonLogger.debug(e.getMessage(), e);
            return skey;
        }
        return result.toString();
    }

    protected String getProperty(String skey) {
        return (String)this.m_hashTable.get(skey);
    }

    protected Object setProperty(String skey, String svalue) {
        if (skey == null || svalue == null) {
            return null;
        }
        return this.m_hashTable.put(skey, svalue);
    }

    @Override
    public void setResourceDir(String fileDir, boolean bAddLocale) {
        String fileDirExt;
        String fileSplit = "";
        if (fileDir.lastIndexOf("/") + 1 != fileDir.length()) {
            fileSplit = "/";
        }
        if ((fileDirExt = fileDir).indexOf("style/defaultstyle/") == 0) {
            fileDirExt = fileDirExt.replaceFirst("style/defaultstyle/", "style/productstyle/");
        }
        if (bAddLocale) {
            this.m_resourceDir = this.m_resourceDir.replace(0, this.m_resourceDir.length(), fileDir + fileSplit + m_locale);
            this.m_extResourceDir = this.m_extResourceDir.replace(0, this.m_extResourceDir.length(), fileDirExt + fileSplit + m_locale);
        } else {
            this.m_resourceDir = this.m_resourceDir.replace(0, this.m_resourceDir.length(), fileDir + fileSplit);
            this.m_extResourceDir = this.m_extResourceDir.replace(0, this.m_extResourceDir.length(), fileDirExt + fileSplit);
        }
    }

    @Override
    public void putMap(Map map) {
        if (map == null) {
            return;
        }
        this.m_hashTable.putAll(map);
    }

    @Override
    public Map getMap() {
        return (Map)this.m_hashTable.clone();
    }

    protected abstract void loadFileExt(String var1);
}

