/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.util;

import com.swimap.iview.util.log.IviewLogger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class EmfIPv6Document
extends PlainDocument {
    public final String VALID_IPv4_STRING = "0123456789.";
    public final String VALID_IPv6_STRING = "0123456789abcdefABCDEF.:";
    public final String VALID_MAC_STRING = "0123456789abcdefABCDEF:";
    private JTextComponent t = null;
    private boolean bCheckMAC = false;
    private static final IviewLogger logger = IviewLogger.getLogger(EmfIPv6Document.class, (String)"TM");

    public EmfIPv6Document(JTextComponent t) {
        this.t = t;
    }

    public EmfIPv6Document(JTextComponent t, boolean bCheckMAC) {
        this.t = t;
        this.bCheckMAC = bCheckMAC;
    }

    @Override
    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s == null) {
            super.insertString(offset, s, attributeSet);
        } else {
            String oldText = this.t.getText();
            String head = oldText.substring(0, offset);
            String tail = oldText.substring(offset, oldText.length());
            String newText = head + s + tail;
            if (this.bCheckMAC) {
                if (this.checkMACInputValid(newText)) {
                    super.insertString(offset, s, attributeSet);
                }
            } else if (this.checkIPInputValid(newText)) {
                super.insertString(offset, s, attributeSet);
            }
        }
    }

    @Override
    public void remove(int offs, int len) {
        String oldText = this.t.getText();
        oldText = oldText.substring(0, offs) + oldText.substring(offs + len);
        if (this.bCheckMAC ? !this.checkMACInputValid(oldText) : !this.checkIPInputValid(oldText)) {
            return;
        }
        try {
            super.remove(offs, len);
        }
        catch (Exception ex) {
            logger.trace((Object)ex);
        }
    }

    protected boolean checkIPInputValid(String strIP) {
        boolean bContainColon;
        boolean bContainDot = -1 != strIP.indexOf(46);
        boolean bl = bContainColon = -1 != strIP.indexOf(58);
        if (bContainDot && bContainColon) {
            return this.isValidString(strIP, 4, 3, 6, 3, ":.", "0123456789abcdefABCDEF.:");
        }
        boolean bContainLetter = false;
        for (int i = 0; i < strIP.length(); ++i) {
            char ch = strIP.charAt(i);
            if (-1 == "0123456789abcdefABCDEF.:".indexOf(ch)) {
                return false;
            }
            if (bContainLetter || '.' == ch || ':' == ch || ch >= '0' && ch <= '9') continue;
            bContainLetter = true;
        }
        if (bContainDot && bContainLetter) {
            return false;
        }
        if (bContainDot) {
            return this.isValidString(strIP, 3, 3, '.', "0123456789.");
        }
        if (bContainColon) {
            return this.isValidString(strIP, 4, 7, ':', "0123456789abcdefABCDEF.:");
        }
        return 4 >= strIP.length();
    }

    protected boolean checkMACInputValid(String strMAC) {
        if (strMAC.length() > 17) {
            return false;
        }
        for (int i = 0; i < strMAC.length(); ++i) {
            char ch = strMAC.charAt(i);
            if (-1 != "0123456789abcdefABCDEF:".indexOf(ch)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidString(String str, int maxPartLen, int maxSplitChCount, char chSplit, String validString) {
        int len = 0;
        int count = 0;
        boolean bPreviousSplitChar = false;
        StringBuffer sb = new StringBuffer(4);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (chSplit != ch) {
                if (-1 == validString.indexOf(ch)) {
                    return false;
                }
                if (++len > maxPartLen) {
                    return false;
                }
                bPreviousSplitChar = false;
                sb.append(ch);
                if (chSplit != '.' || this.isValidIPv4Segment(sb)) continue;
                return false;
            }
            if (bPreviousSplitChar) {
                return false;
            }
            len = 0;
            sb = new StringBuffer(4);
            bPreviousSplitChar = true;
            if (++count <= maxSplitChCount) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidString(String str, int maxPartLenPre, int maxPartLenNext, int maxPartCountPre, int maxPartCountNext, String chSplit, String validString) {
        int len = 0;
        int countColon = 0;
        int countDot = 0;
        boolean bStartV4 = false;
        boolean bPreviousSplitChar = false;
        StringBuffer sb = new StringBuffer(4);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (-1 == chSplit.indexOf(ch)) {
                if (-1 == validString.indexOf(ch)) {
                    return false;
                }
                if (++len > (bStartV4 || countDot > 0 ? maxPartLenNext : maxPartLenPre)) {
                    return false;
                }
                bPreviousSplitChar = false;
                sb.append(ch);
                if (!bStartV4 && countDot <= 0) continue;
                if (-1 == "0123456789.".indexOf(ch)) {
                    return false;
                }
                if (this.isValidIPv4Segment(sb)) continue;
                return false;
            }
            if (bPreviousSplitChar) {
                return false;
            }
            bPreviousSplitChar = true;
            if (ch == '.' && !this.isValidIPv4Segment(sb)) {
                return false;
            }
            len = 0;
            sb = new StringBuffer(4);
            if (ch == ':') {
                if (countDot > 0) {
                    return false;
                }
                ++countColon;
            } else {
                ++countDot;
            }
            if (countColon == maxPartCountPre) {
                bStartV4 = true;
            }
            if (countColon > maxPartCountPre) {
                return false;
            }
            if (countDot <= maxPartCountNext) continue;
            return false;
        }
        return true;
    }

    private boolean isValidIPv4Segment(StringBuffer sb) {
        try {
            int value = Integer.parseInt(sb.toString());
            return value >= 0 && value <= 255;
        }
        catch (Exception ex) {
            logger.trace((Object)sb.toString());
            return false;
        }
    }
}

