/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.SessionUserID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class UserReq
implements FStruct {
    public SessionUserID sessionUserID = new SessionUserID();
    public byte[] ipAddress = null;

    public UserReq() {
    }

    public UserReq(UserReq arg) {
        this.sessionUserID = new SessionUserID(arg.sessionUserID);
        if (arg.ipAddress != null) {
            this.ipAddress = new byte[arg.ipAddress.length];
            System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.sessionUserID.serialize(enc);
        if (this.ipAddress != null) {
            enc.serializeOctetString(this.ipAddress);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.sessionUserID.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.ipAddress = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sessionUserID = ");
        this.sessionUserID.print(os, indent + 2);
        os.println(',');
        if (this.ipAddress != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("ipAddress = ");
            os.print(FStruFormat.convertToString((byte[])this.ipAddress));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

