/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.UserLoginReqSeqOf;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class UserLoginReq
implements FStruct {
    public byte[] userName;
    public byte[] password;
    public BigInteger clientType;
    public byte[] ipAddress = null;
    public UserLoginReqSeqOf paraList = null;

    public UserLoginReq() {
    }

    public UserLoginReq(UserLoginReq arg) {
        this.userName = new byte[arg.userName.length];
        System.arraycopy(arg.userName, 0, this.userName, 0, arg.userName.length);
        this.password = new byte[arg.password.length];
        System.arraycopy(arg.password, 0, this.password, 0, arg.password.length);
        this.clientType = arg.clientType;
        if (arg.ipAddress != null) {
            this.ipAddress = new byte[arg.ipAddress.length];
            System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
        }
        if (arg.paraList != null) {
            this.paraList = new UserLoginReqSeqOf(arg.paraList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.userName);
        enc.serializeOctetString(this.password);
        enc.serializeInteger(this.clientType);
        if (this.ipAddress != null) {
            enc.serializeOctetString(this.ipAddress);
        }
        if (this.paraList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.paraList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userName = dec.deserializeOctetString();
        this.password = dec.deserializeOctetString();
        this.clientType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.ipAddress = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.paraList = new UserLoginReqSeqOf();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.paraList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userName = ");
        os.print(FStruFormat.convertToString((byte[])this.userName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("password = ");
        os.print(FStruFormat.convertToString((byte[])this.password));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clientType = ");
        os.print(this.clientType.toString());
        os.println(',');
        if (this.ipAddress != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("ipAddress = ");
            os.print(FStruFormat.convertToString((byte[])this.ipAddress));
            os.println(',');
        }
        if (this.paraList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("paraList = ");
            this.paraList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

