/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.ValidHourMinuteSegmentList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class UserCommonAttr
implements FStruct {
    public byte[] userName;
    public byte[] fullName;
    public byte[] description;
    public boolean userValidForever;
    public BigInteger userValidDays;
    public boolean isAutoLogout;
    public BigInteger autoLogoutInterval;
    public boolean pwdValidForever;
    public BigInteger pwdValidDays;
    public boolean userIsLocked;
    public BigInteger loginMaxInterval;
    public boolean isMustChangePass;
    public BigInteger maxLoginNum;
    public ValidHourMinuteSegmentList validHourMinuteSegmentList = null;
    public BigInteger securityLevel = null;

    public UserCommonAttr() {
    }

    public UserCommonAttr(UserCommonAttr arg) {
        this.userName = new byte[arg.userName.length];
        System.arraycopy(arg.userName, 0, this.userName, 0, arg.userName.length);
        this.fullName = new byte[arg.fullName.length];
        System.arraycopy(arg.fullName, 0, this.fullName, 0, arg.fullName.length);
        this.description = new byte[arg.description.length];
        System.arraycopy(arg.description, 0, this.description, 0, arg.description.length);
        this.userValidForever = arg.userValidForever;
        this.userValidDays = arg.userValidDays;
        this.isAutoLogout = arg.isAutoLogout;
        this.autoLogoutInterval = arg.autoLogoutInterval;
        this.pwdValidForever = arg.pwdValidForever;
        this.pwdValidDays = arg.pwdValidDays;
        this.userIsLocked = arg.userIsLocked;
        this.loginMaxInterval = arg.loginMaxInterval;
        this.isMustChangePass = arg.isMustChangePass;
        this.maxLoginNum = arg.maxLoginNum;
        if (arg.validHourMinuteSegmentList != null) {
            this.validHourMinuteSegmentList = new ValidHourMinuteSegmentList(arg.validHourMinuteSegmentList);
        }
        if (arg.securityLevel != null) {
            this.securityLevel = arg.securityLevel;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.userName);
        enc.serializeOctetString(this.fullName);
        enc.serializeOctetString(this.description);
        enc.serializeBoolean(this.userValidForever);
        enc.serializeInteger(this.userValidDays);
        enc.serializeBoolean(this.isAutoLogout);
        enc.serializeInteger(this.autoLogoutInterval);
        enc.serializeBoolean(this.pwdValidForever);
        enc.serializeInteger(this.pwdValidDays);
        enc.serializeBoolean(this.userIsLocked);
        enc.serializeInteger(this.loginMaxInterval);
        enc.serializeBoolean(this.isMustChangePass);
        enc.serializeInteger(this.maxLoginNum);
        if (this.validHourMinuteSegmentList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.validHourMinuteSegmentList.serialize(enc);
        }
        if (this.securityLevel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.securityLevel);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userName = dec.deserializeOctetString();
        this.fullName = dec.deserializeOctetString();
        this.description = dec.deserializeOctetString();
        this.userValidForever = dec.deserializeBoolean();
        this.userValidDays = dec.deserializeInteger();
        this.isAutoLogout = dec.deserializeBoolean();
        this.autoLogoutInterval = dec.deserializeInteger();
        this.pwdValidForever = dec.deserializeBoolean();
        this.pwdValidDays = dec.deserializeInteger();
        this.userIsLocked = dec.deserializeBoolean();
        this.loginMaxInterval = dec.deserializeInteger();
        this.isMustChangePass = dec.deserializeBoolean();
        this.maxLoginNum = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.validHourMinuteSegmentList = new ValidHourMinuteSegmentList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.validHourMinuteSegmentList.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.securityLevel = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userName = ");
        os.print(FStruFormat.convertToString((byte[])this.userName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fullName = ");
        os.print(FStruFormat.convertToString((byte[])this.fullName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("description = ");
        os.print(FStruFormat.convertToString((byte[])this.description));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userValidForever = ");
        os.print(this.userValidForever);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userValidDays = ");
        os.print(this.userValidDays.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isAutoLogout = ");
        os.print(this.isAutoLogout);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("autoLogoutInterval = ");
        os.print(this.autoLogoutInterval.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pwdValidForever = ");
        os.print(this.pwdValidForever);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pwdValidDays = ");
        os.print(this.pwdValidDays.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userIsLocked = ");
        os.print(this.userIsLocked);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("loginMaxInterval = ");
        os.print(this.loginMaxInterval.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isMustChangePass = ");
        os.print(this.isMustChangePass);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("maxLoginNum = ");
        os.print(this.maxLoginNum.toString());
        os.println(',');
        if (this.validHourMinuteSegmentList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("validHourMinuteSegmentList = ");
            this.validHourMinuteSegmentList.print(os, indent + 2);
            os.println(',');
        }
        if (this.securityLevel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("securityLevel = ");
            os.print(this.securityLevel.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

