/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.TypeOperateInfoSeqOf;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class TypeOperateInfo
implements FStruct {
    public BigInteger mainType;
    public BigInteger subType;
    public TypeOperateInfoSeqOf operateIDList = new TypeOperateInfoSeqOf();

    public TypeOperateInfo() {
    }

    public TypeOperateInfo(TypeOperateInfo arg) {
        this.mainType = arg.mainType;
        this.subType = arg.subType;
        this.operateIDList = new TypeOperateInfoSeqOf(arg.operateIDList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.mainType);
        enc.serializeInteger(this.subType);
        this.operateIDList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.mainType = dec.deserializeInteger();
        this.subType = dec.deserializeInteger();
        this.operateIDList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mainType = ");
        os.print(this.mainType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subType = ");
        os.print(this.subType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operateIDList = ");
        this.operateIDList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

