/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class OperateSetCommonAttr
implements FStruct {
    public byte[] operateSetName;
    public BigInteger mainType;
    public BigInteger subType;
    public byte[] description;

    public OperateSetCommonAttr() {
    }

    public OperateSetCommonAttr(OperateSetCommonAttr arg) {
        this.operateSetName = new byte[arg.operateSetName.length];
        System.arraycopy(arg.operateSetName, 0, this.operateSetName, 0, arg.operateSetName.length);
        this.mainType = arg.mainType;
        this.subType = arg.subType;
        this.description = new byte[arg.description.length];
        System.arraycopy(arg.description, 0, this.description, 0, arg.description.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.operateSetName);
        enc.serializeInteger(this.mainType);
        enc.serializeInteger(this.subType);
        enc.serializeOctetString(this.description);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.operateSetName = dec.deserializeOctetString();
        this.mainType = dec.deserializeInteger();
        this.subType = dec.deserializeInteger();
        this.description = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operateSetName = ");
        os.print(FStruFormat.convertToString((byte[])this.operateSetName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mainType = ");
        os.print(this.mainType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subType = ");
        os.print(this.subType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("description = ");
        os.print(FStruFormat.convertToString((byte[])this.description));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

