/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.CmdAttr;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class OperateInfo
implements FStruct {
    public CmdAttr operateCode = new CmdAttr();
    public byte[] operateName = null;
    public BigInteger operateType = null;
    public BigInteger operateIsRightCheck = null;
    public BigInteger operatePerilLevel = null;

    public OperateInfo() {
    }

    public OperateInfo(OperateInfo arg) {
        this.operateCode = new CmdAttr(arg.operateCode);
        if (arg.operateName != null) {
            this.operateName = new byte[arg.operateName.length];
            System.arraycopy(arg.operateName, 0, this.operateName, 0, arg.operateName.length);
        }
        if (arg.operateType != null) {
            this.operateType = arg.operateType;
        }
        if (arg.operateIsRightCheck != null) {
            this.operateIsRightCheck = arg.operateIsRightCheck;
        }
        if (arg.operatePerilLevel != null) {
            this.operatePerilLevel = arg.operatePerilLevel;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.operateCode.serialize(enc);
        if (this.operateName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.operateName);
        }
        if (this.operateType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.operateType);
        }
        if (this.operateIsRightCheck != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.operateIsRightCheck);
        }
        if (this.operatePerilLevel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.operatePerilLevel);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.operateCode.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.operateName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.operateType = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.operateIsRightCheck = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.operatePerilLevel = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operateCode = ");
        this.operateCode.print(os, indent + 2);
        os.println(',');
        if (this.operateName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("operateName = ");
            os.print(FStruFormat.convertToString((byte[])this.operateName));
            os.println(',');
        }
        if (this.operateType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("operateType = ");
            os.print(this.operateType.toString());
            os.println(',');
        }
        if (this.operateIsRightCheck != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("operateIsRightCheck = ");
            os.print(this.operateIsRightCheck.toString());
            os.println(',');
        }
        if (this.operatePerilLevel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("operatePerilLevel = ");
            os.print(this.operatePerilLevel.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

