/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class OperateAuthorityID
implements FStruct {
    public BigInteger guID;
    public BigInteger objectNumber;
    public BigInteger mainType;
    public BigInteger subType;
    public BigInteger operateCmd;
    public BigInteger objectType = null;

    public OperateAuthorityID() {
    }

    public OperateAuthorityID(OperateAuthorityID arg) {
        this.guID = arg.guID;
        this.objectNumber = arg.objectNumber;
        this.mainType = arg.mainType;
        this.subType = arg.subType;
        this.operateCmd = arg.operateCmd;
        if (arg.objectType != null) {
            this.objectType = arg.objectType;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.guID);
        enc.serializeInteger(this.objectNumber);
        enc.serializeInteger(this.mainType);
        enc.serializeInteger(this.subType);
        enc.serializeInteger(this.operateCmd);
        if (this.objectType != null) {
            enc.serializeInteger(this.objectType);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.guID = dec.deserializeInteger();
        this.objectNumber = dec.deserializeInteger();
        this.mainType = dec.deserializeInteger();
        this.subType = dec.deserializeInteger();
        this.operateCmd = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.objectType = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("guID = ");
        os.print(this.guID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectNumber = ");
        os.print(this.objectNumber.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mainType = ");
        os.print(this.mainType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subType = ");
        os.print(this.subType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operateCmd = ");
        os.print(this.operateCmd.toString());
        os.println(',');
        if (this.objectType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("objectType = ");
            os.print(this.objectType.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

