/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class ManagableAuthorityID
implements FStruct {
    public BigInteger iGUID;
    public byte[] strResDN;
    public BigInteger iResType;
    public BigInteger iResSubType;
    public byte[] strSubmapID = null;

    public ManagableAuthorityID() {
    }

    public ManagableAuthorityID(ManagableAuthorityID arg) {
        this.iGUID = arg.iGUID;
        this.strResDN = new byte[arg.strResDN.length];
        System.arraycopy(arg.strResDN, 0, this.strResDN, 0, arg.strResDN.length);
        this.iResType = arg.iResType;
        this.iResSubType = arg.iResSubType;
        if (arg.strSubmapID != null) {
            this.strSubmapID = new byte[arg.strSubmapID.length];
            System.arraycopy(arg.strSubmapID, 0, this.strSubmapID, 0, arg.strSubmapID.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iGUID);
        enc.serializeOctetString(this.strResDN);
        enc.serializeInteger(this.iResType);
        enc.serializeInteger(this.iResSubType);
        if (this.strSubmapID != null) {
            enc.serializeOctetString(this.strSubmapID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iGUID = dec.deserializeInteger();
        this.strResDN = dec.deserializeOctetString();
        this.iResType = dec.deserializeInteger();
        this.iResSubType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.strSubmapID = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iGUID = ");
        os.print(this.iGUID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strResDN = ");
        os.print(FStruFormat.convertToString((byte[])this.strResDN));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResType = ");
        os.print(this.iResType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResSubType = ");
        os.print(this.iResSubType.toString());
        os.println(',');
        if (this.strSubmapID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strSubmapID = ");
            os.print(FStruFormat.convertToString((byte[])this.strSubmapID));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

