/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class LicenseItemInfo
implements FStruct {
    public byte[] product = null;
    public byte[] feature;
    public byte[] item;
    public BigInteger value;
    public BigInteger result;

    public LicenseItemInfo() {
    }

    public LicenseItemInfo(LicenseItemInfo arg) {
        if (arg.product != null) {
            this.product = new byte[arg.product.length];
            System.arraycopy(arg.product, 0, this.product, 0, arg.product.length);
        }
        this.feature = new byte[arg.feature.length];
        System.arraycopy(arg.feature, 0, this.feature, 0, arg.feature.length);
        this.item = new byte[arg.item.length];
        System.arraycopy(arg.item, 0, this.item, 0, arg.item.length);
        this.value = arg.value;
        this.result = arg.result;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        if (this.product != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.product);
        }
        enc.serializeOctetString(this.feature);
        enc.serializeOctetString(this.item);
        enc.serializeInteger(this.value);
        enc.serializeInteger(this.result);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.product = dec.deserializeOctetString();
        }
        this.feature = dec.deserializeOctetString();
        this.item = dec.deserializeOctetString();
        this.value = dec.deserializeInteger();
        this.result = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.product != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("product = ");
            os.print(FStruFormat.convertToString((byte[])this.product));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("feature = ");
        os.print(FStruFormat.convertToString((byte[])this.feature));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("item = ");
        os.print(FStruFormat.convertToString((byte[])this.item));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(this.value.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("result = ");
        os.print(this.result.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

