/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class LicenseApplyInfo
implements FStruct {
    public byte[] feature;
    public byte[] item;
    public byte[] subitem = null;
    public byte[] value;

    public LicenseApplyInfo() {
    }

    public LicenseApplyInfo(LicenseApplyInfo arg) {
        this.feature = new byte[arg.feature.length];
        System.arraycopy(arg.feature, 0, this.feature, 0, arg.feature.length);
        this.item = new byte[arg.item.length];
        System.arraycopy(arg.item, 0, this.item, 0, arg.item.length);
        if (arg.subitem != null) {
            this.subitem = new byte[arg.subitem.length];
            System.arraycopy(arg.subitem, 0, this.subitem, 0, arg.subitem.length);
        }
        this.value = new byte[arg.value.length];
        System.arraycopy(arg.value, 0, this.value, 0, arg.value.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.feature);
        enc.serializeOctetString(this.item);
        if (this.subitem != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.subitem);
        }
        enc.serializeOctetString(this.value);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.feature = dec.deserializeOctetString();
        this.item = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.subitem = dec.deserializeOctetString();
        }
        this.value = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("feature = ");
        os.print(FStruFormat.convertToString((byte[])this.feature));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("item = ");
        os.print(FStruFormat.convertToString((byte[])this.item));
        os.println(',');
        if (this.subitem != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("subitem = ");
            os.print(FStruFormat.convertToString((byte[])this.subitem));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(FStruFormat.convertToString((byte[])this.value));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

