/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class GroupCommonAttr
implements FStruct {
    public byte[] groupName;
    public byte[] description;
    public BigInteger maxAllowSession;
    public BigInteger groupLevel = null;

    public GroupCommonAttr() {
    }

    public GroupCommonAttr(GroupCommonAttr arg) {
        this.groupName = new byte[arg.groupName.length];
        System.arraycopy(arg.groupName, 0, this.groupName, 0, arg.groupName.length);
        this.description = new byte[arg.description.length];
        System.arraycopy(arg.description, 0, this.description, 0, arg.description.length);
        this.maxAllowSession = arg.maxAllowSession;
        if (arg.groupLevel != null) {
            this.groupLevel = arg.groupLevel;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.groupName);
        enc.serializeOctetString(this.description);
        enc.serializeInteger(this.maxAllowSession);
        if (this.groupLevel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.groupLevel);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.groupName = dec.deserializeOctetString();
        this.description = dec.deserializeOctetString();
        this.maxAllowSession = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.groupLevel = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("groupName = ");
        os.print(FStruFormat.convertToString((byte[])this.groupName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("description = ");
        os.print(FStruFormat.convertToString((byte[])this.description));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("maxAllowSession = ");
        os.print(this.maxAllowSession.toString());
        os.println(',');
        if (this.groupLevel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("groupLevel = ");
            os.print(this.groupLevel.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

