/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsniMAPScheduleRunReq
implements FStruct {
    public byte[] userInfo;
    public BigInteger taskID;
    public BigInteger taskType;
    public byte[] taskParam;

    public AsniMAPScheduleRunReq() {
    }

    public AsniMAPScheduleRunReq(AsniMAPScheduleRunReq arg) {
        this.userInfo = new byte[arg.userInfo.length];
        System.arraycopy(arg.userInfo, 0, this.userInfo, 0, arg.userInfo.length);
        this.taskID = arg.taskID;
        this.taskType = arg.taskType;
        this.taskParam = new byte[arg.taskParam.length];
        System.arraycopy(arg.taskParam, 0, this.taskParam, 0, arg.taskParam.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.userInfo);
        enc.serializeInteger(this.taskID);
        enc.serializeInteger(this.taskType);
        enc.serializeOctetString(this.taskParam);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userInfo = dec.deserializeOctetString();
        this.taskID = dec.deserializeInteger();
        this.taskType = dec.deserializeInteger();
        this.taskParam = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userInfo = ");
        os.print(FStruFormat.convertToString((byte[])this.userInfo));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("taskID = ");
        os.print(this.taskID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("taskType = ");
        os.print(this.taskType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("taskParam = ");
        os.print(FStruFormat.convertToString((byte[])this.taskParam));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

