/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsniMAPDateTime;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsniMAPScheduleCreateReq
implements FStruct {
    public byte[] userInfo;
    public byte[] jobName;
    public BigInteger jobType;
    public BigInteger scheduleType;
    public BigInteger schedule;
    public AsniMAPDateTime startTime = null;
    public byte[] appParam = null;
    public BigInteger retryTimes;
    public BigInteger retryPeriod;
    public boolean bPartRetry;
    public BigInteger runTimes;
    public boolean bExecute;

    public AsniMAPScheduleCreateReq() {
    }

    public AsniMAPScheduleCreateReq(AsniMAPScheduleCreateReq arg) {
        this.userInfo = new byte[arg.userInfo.length];
        System.arraycopy(arg.userInfo, 0, this.userInfo, 0, arg.userInfo.length);
        this.jobName = new byte[arg.jobName.length];
        System.arraycopy(arg.jobName, 0, this.jobName, 0, arg.jobName.length);
        this.jobType = arg.jobType;
        this.scheduleType = arg.scheduleType;
        this.schedule = arg.schedule;
        if (arg.startTime != null) {
            this.startTime = new AsniMAPDateTime(arg.startTime);
        }
        if (arg.appParam != null) {
            this.appParam = new byte[arg.appParam.length];
            System.arraycopy(arg.appParam, 0, this.appParam, 0, arg.appParam.length);
        }
        this.retryTimes = arg.retryTimes;
        this.retryPeriod = arg.retryPeriod;
        this.bPartRetry = arg.bPartRetry;
        this.runTimes = arg.runTimes;
        this.bExecute = arg.bExecute;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.userInfo);
        enc.serializeOctetString(this.jobName);
        enc.serializeInteger(this.jobType);
        enc.serializeInteger(this.scheduleType);
        enc.serializeInteger(this.schedule);
        if (this.startTime != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.startTime.serialize(enc);
        }
        if (this.appParam != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.appParam);
        }
        enc.serializeInteger(this.retryTimes);
        enc.serializeInteger(this.retryPeriod);
        enc.serializeBoolean(this.bPartRetry);
        enc.serializeInteger(this.runTimes);
        enc.serializeBoolean(this.bExecute);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.userInfo = dec.deserializeOctetString();
        this.jobName = dec.deserializeOctetString();
        this.jobType = dec.deserializeInteger();
        this.scheduleType = dec.deserializeInteger();
        this.schedule = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.startTime = new AsniMAPDateTime();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.startTime.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.appParam = dec.deserializeOctetString();
        }
        this.retryTimes = dec.deserializeInteger();
        this.retryPeriod = dec.deserializeInteger();
        this.bPartRetry = dec.deserializeBoolean();
        this.runTimes = dec.deserializeInteger();
        this.bExecute = dec.deserializeBoolean();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userInfo = ");
        os.print(FStruFormat.convertToString((byte[])this.userInfo));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("jobName = ");
        os.print(FStruFormat.convertToString((byte[])this.jobName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("jobType = ");
        os.print(this.jobType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("scheduleType = ");
        os.print(this.scheduleType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("schedule = ");
        os.print(this.schedule.toString());
        os.println(',');
        if (this.startTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("startTime = ");
            this.startTime.print(os, indent + 2);
            os.println(',');
        }
        if (this.appParam != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("appParam = ");
            os.print(FStruFormat.convertToString((byte[])this.appParam));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("retryTimes = ");
        os.print(this.retryTimes.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("retryPeriod = ");
        os.print(this.retryPeriod.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bPartRetry = ");
        os.print(this.bPartRetry);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("runTimes = ");
        os.print(this.runTimes.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bExecute = ");
        os.print(this.bExecute);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

