/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsniFMSUnionError
implements FStruct {
    public BigInteger lSerialNo;
    public BigInteger lSessionID;
    public BigInteger lErrorCode;
    public BigInteger ucOPType;
    public byte[] strDetail = null;
    public byte[] strReserved = null;

    public AsniFMSUnionError() {
    }

    public AsniFMSUnionError(AsniFMSUnionError arg) {
        this.lSerialNo = arg.lSerialNo;
        this.lSessionID = arg.lSessionID;
        this.lErrorCode = arg.lErrorCode;
        this.ucOPType = arg.ucOPType;
        if (arg.strDetail != null) {
            this.strDetail = new byte[arg.strDetail.length];
            System.arraycopy(arg.strDetail, 0, this.strDetail, 0, arg.strDetail.length);
        }
        if (arg.strReserved != null) {
            this.strReserved = new byte[arg.strReserved.length];
            System.arraycopy(arg.strReserved, 0, this.strReserved, 0, arg.strReserved.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.lSerialNo);
        enc.serializeInteger(this.lSessionID);
        enc.serializeInteger(this.lErrorCode);
        enc.serializeInteger(this.ucOPType);
        if (this.strDetail != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strDetail);
        }
        if (this.strReserved != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strReserved);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lSerialNo = dec.deserializeInteger();
        this.lSessionID = dec.deserializeInteger();
        this.lErrorCode = dec.deserializeInteger();
        this.ucOPType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strDetail = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strReserved = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lSerialNo = ");
        os.print(this.lSerialNo.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lSessionID = ");
        os.print(this.lSessionID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lErrorCode = ");
        os.print(this.lErrorCode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ucOPType = ");
        os.print(this.ucOPType.toString());
        os.println(',');
        if (this.strDetail != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDetail = ");
            os.print(FStruFormat.convertToString((byte[])this.strDetail));
            os.println(',');
        }
        if (this.strReserved != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strReserved = ");
            os.print(FStruFormat.convertToString((byte[])this.strReserved));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

