/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnUsedLicenseDetailInfo
implements FStruct {
    public BigInteger iMainType;
    public BigInteger iSubType;
    public byte[] strMainType;
    public byte[] strSubType;
    public byte[] strUsedLicense;

    public AsnUsedLicenseDetailInfo() {
    }

    public AsnUsedLicenseDetailInfo(AsnUsedLicenseDetailInfo arg) {
        this.iMainType = arg.iMainType;
        this.iSubType = arg.iSubType;
        this.strMainType = new byte[arg.strMainType.length];
        System.arraycopy(arg.strMainType, 0, this.strMainType, 0, arg.strMainType.length);
        this.strSubType = new byte[arg.strSubType.length];
        System.arraycopy(arg.strSubType, 0, this.strSubType, 0, arg.strSubType.length);
        this.strUsedLicense = new byte[arg.strUsedLicense.length];
        System.arraycopy(arg.strUsedLicense, 0, this.strUsedLicense, 0, arg.strUsedLicense.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iMainType);
        enc.serializeInteger(this.iSubType);
        enc.serializeOctetString(this.strMainType);
        enc.serializeOctetString(this.strSubType);
        enc.serializeOctetString(this.strUsedLicense);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iMainType = dec.deserializeInteger();
        this.iSubType = dec.deserializeInteger();
        this.strMainType = dec.deserializeOctetString();
        this.strSubType = dec.deserializeOctetString();
        this.strUsedLicense = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iMainType = ");
        os.print(this.iMainType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSubType = ");
        os.print(this.iSubType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strMainType = ");
        os.print(FStruFormat.convertToString((byte[])this.strMainType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSubType = ");
        os.print(FStruFormat.convertToString((byte[])this.strSubType));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUsedLicense = ");
        os.print(FStruFormat.convertToString((byte[])this.strUsedLicense));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

