/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTopoObjectOperResult
implements FStruct {
    public BigInteger iTopoObjType;
    public BigInteger iErrorCode;
    public byte[] strObjectID = null;
    public byte[] strObjectParentID = null;
    public BigInteger iView = null;
    public byte[] strObjectName = null;

    public AsnTopoObjectOperResult() {
    }

    public AsnTopoObjectOperResult(AsnTopoObjectOperResult arg) {
        this.iTopoObjType = arg.iTopoObjType;
        this.iErrorCode = arg.iErrorCode;
        if (arg.strObjectID != null) {
            this.strObjectID = new byte[arg.strObjectID.length];
            System.arraycopy(arg.strObjectID, 0, this.strObjectID, 0, arg.strObjectID.length);
        }
        if (arg.strObjectParentID != null) {
            this.strObjectParentID = new byte[arg.strObjectParentID.length];
            System.arraycopy(arg.strObjectParentID, 0, this.strObjectParentID, 0, arg.strObjectParentID.length);
        }
        if (arg.iView != null) {
            this.iView = arg.iView;
        }
        if (arg.strObjectName != null) {
            this.strObjectName = new byte[arg.strObjectName.length];
            System.arraycopy(arg.strObjectName, 0, this.strObjectName, 0, arg.strObjectName.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iTopoObjType);
        enc.serializeInteger(this.iErrorCode);
        if (this.strObjectID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strObjectID);
        }
        if (this.strObjectParentID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strObjectParentID);
        }
        if (this.iView != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iView);
        }
        if (this.strObjectName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.strObjectName);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iTopoObjType = dec.deserializeInteger();
        this.iErrorCode = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strObjectID = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strObjectParentID = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.iView = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.strObjectName = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iTopoObjType = ");
        os.print(this.iTopoObjType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iErrorCode = ");
        os.print(this.iErrorCode.toString());
        os.println(',');
        if (this.strObjectID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strObjectID = ");
            os.print(FStruFormat.convertToString((byte[])this.strObjectID));
            os.println(',');
        }
        if (this.strObjectParentID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strObjectParentID = ");
            os.print(FStruFormat.convertToString((byte[])this.strObjectParentID));
            os.println(',');
        }
        if (this.iView != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iView = ");
            os.print(this.iView.toString());
            os.println(',');
        }
        if (this.strObjectName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strObjectName = ");
            os.print(FStruFormat.convertToString((byte[])this.strObjectName));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

