/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTopoObjAttrTab
implements FStruct {
    public BigInteger iUserID;
    public BigInteger iAttrID;
    public byte[] strValue;

    public AsnTopoObjAttrTab() {
    }

    public AsnTopoObjAttrTab(AsnTopoObjAttrTab arg) {
        this.iUserID = arg.iUserID;
        this.iAttrID = arg.iAttrID;
        this.strValue = new byte[arg.strValue.length];
        System.arraycopy(arg.strValue, 0, this.strValue, 0, arg.strValue.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iUserID);
        enc.serializeInteger(this.iAttrID);
        enc.serializeOctetString(this.strValue);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iUserID = dec.deserializeInteger();
        this.iAttrID = dec.deserializeInteger();
        this.strValue = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserID = ");
        os.print(this.iUserID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iAttrID = ");
        os.print(this.iAttrID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strValue = ");
        os.print(FStruFormat.convertToString((byte[])this.strValue));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

