/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnTMKEY2SVAL
implements FStruct {
    public byte[] asnKey;
    public byte[] asnVal;

    public AsnTMKEY2SVAL() {
    }

    public AsnTMKEY2SVAL(AsnTMKEY2SVAL arg) {
        this.asnKey = new byte[arg.asnKey.length];
        System.arraycopy(arg.asnKey, 0, this.asnKey, 0, arg.asnKey.length);
        this.asnVal = new byte[arg.asnVal.length];
        System.arraycopy(arg.asnVal, 0, this.asnVal, 0, arg.asnVal.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.asnKey);
        enc.serializeOctetString(this.asnVal);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.asnKey = dec.deserializeOctetString();
        this.asnVal = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("asnKey = ");
        os.print(FStruFormat.convertToString((byte[])this.asnKey));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("asnVal = ");
        os.print(FStruFormat.convertToString((byte[])this.asnVal));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

