/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnParaList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSyslogServerInfo
implements FStruct {
    public BigInteger no;
    public byte[] masterIP;
    public BigInteger masterPort;
    public byte[] slaveIP;
    public BigInteger slavePort;
    public BigInteger protocal;
    public BigInteger enable;
    public BigInteger status;
    public BigInteger severeLevel;
    public byte[] strfilter;
    public byte[] remark;
    public AsnParaList paraList = new AsnParaList();

    public AsnSyslogServerInfo() {
    }

    public AsnSyslogServerInfo(AsnSyslogServerInfo arg) {
        this.no = arg.no;
        this.masterIP = new byte[arg.masterIP.length];
        System.arraycopy(arg.masterIP, 0, this.masterIP, 0, arg.masterIP.length);
        this.masterPort = arg.masterPort;
        this.slaveIP = new byte[arg.slaveIP.length];
        System.arraycopy(arg.slaveIP, 0, this.slaveIP, 0, arg.slaveIP.length);
        this.slavePort = arg.slavePort;
        this.protocal = arg.protocal;
        this.enable = arg.enable;
        this.status = arg.status;
        this.severeLevel = arg.severeLevel;
        this.strfilter = new byte[arg.strfilter.length];
        System.arraycopy(arg.strfilter, 0, this.strfilter, 0, arg.strfilter.length);
        this.remark = new byte[arg.remark.length];
        System.arraycopy(arg.remark, 0, this.remark, 0, arg.remark.length);
        this.paraList = new AsnParaList(arg.paraList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.no);
        enc.serializeOctetString(this.masterIP);
        enc.serializeInteger(this.masterPort);
        enc.serializeOctetString(this.slaveIP);
        enc.serializeInteger(this.slavePort);
        enc.serializeInteger(this.protocal);
        enc.serializeInteger(this.enable);
        enc.serializeInteger(this.status);
        enc.serializeInteger(this.severeLevel);
        enc.serializeOctetString(this.strfilter);
        enc.serializeOctetString(this.remark);
        this.paraList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.no = dec.deserializeInteger();
        this.masterIP = dec.deserializeOctetString();
        this.masterPort = dec.deserializeInteger();
        this.slaveIP = dec.deserializeOctetString();
        this.slavePort = dec.deserializeInteger();
        this.protocal = dec.deserializeInteger();
        this.enable = dec.deserializeInteger();
        this.status = dec.deserializeInteger();
        this.severeLevel = dec.deserializeInteger();
        this.strfilter = dec.deserializeOctetString();
        this.remark = dec.deserializeOctetString();
        this.paraList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("no = ");
        os.print(this.no.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("masterIP = ");
        os.print(FStruFormat.convertToString((byte[])this.masterIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("masterPort = ");
        os.print(this.masterPort.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("slaveIP = ");
        os.print(FStruFormat.convertToString((byte[])this.slaveIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("slavePort = ");
        os.print(this.slavePort.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protocal = ");
        os.print(this.protocal.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enable = ");
        os.print(this.enable.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("status = ");
        os.print(this.status.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("severeLevel = ");
        os.print(this.severeLevel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strfilter = ");
        os.print(FStruFormat.convertToString((byte[])this.strfilter));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("remark = ");
        os.print(FStruFormat.convertToString((byte[])this.remark));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("paraList = ");
        this.paraList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

