/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSvrManageAttribute
implements FStruct {
    public BigInteger lDevID;
    public BigInteger lOperationType;
    public BigInteger lAttributeType;
    public byte[] strInAttribute;
    public byte[] strOutAttribute;

    public AsnSvrManageAttribute() {
    }

    public AsnSvrManageAttribute(AsnSvrManageAttribute arg) {
        this.lDevID = arg.lDevID;
        this.lOperationType = arg.lOperationType;
        this.lAttributeType = arg.lAttributeType;
        this.strInAttribute = new byte[arg.strInAttribute.length];
        System.arraycopy(arg.strInAttribute, 0, this.strInAttribute, 0, arg.strInAttribute.length);
        this.strOutAttribute = new byte[arg.strOutAttribute.length];
        System.arraycopy(arg.strOutAttribute, 0, this.strOutAttribute, 0, arg.strOutAttribute.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.lDevID);
        enc.serializeInteger(this.lOperationType);
        enc.serializeInteger(this.lAttributeType);
        enc.serializeOctetString(this.strInAttribute);
        enc.serializeOctetString(this.strOutAttribute);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lDevID = dec.deserializeInteger();
        this.lOperationType = dec.deserializeInteger();
        this.lAttributeType = dec.deserializeInteger();
        this.strInAttribute = dec.deserializeOctetString();
        this.strOutAttribute = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lDevID = ");
        os.print(this.lDevID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lOperationType = ");
        os.print(this.lOperationType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lAttributeType = ");
        os.print(this.lAttributeType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strInAttribute = ");
        os.print(FStruFormat.convertToString((byte[])this.strInAttribute));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strOutAttribute = ");
        os.print(FStruFormat.convertToString((byte[])this.strOutAttribute));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

