/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSubnetTab
implements FStruct {
    public byte[] strSubnetIP;
    public byte[] strSubnetMask;

    public AsnSubnetTab() {
    }

    public AsnSubnetTab(AsnSubnetTab arg) {
        this.strSubnetIP = new byte[arg.strSubnetIP.length];
        System.arraycopy(arg.strSubnetIP, 0, this.strSubnetIP, 0, arg.strSubnetIP.length);
        this.strSubnetMask = new byte[arg.strSubnetMask.length];
        System.arraycopy(arg.strSubnetMask, 0, this.strSubnetMask, 0, arg.strSubnetMask.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strSubnetIP);
        enc.serializeOctetString(this.strSubnetMask);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strSubnetIP = dec.deserializeOctetString();
        this.strSubnetMask = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSubnetIP = ");
        os.print(FStruFormat.convertToString((byte[])this.strSubnetIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSubnetMask = ");
        os.print(FStruFormat.convertToString((byte[])this.strSubnetMask));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

