/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSubmapPos
implements FStruct {
    public byte[] strSubmapID;
    public BigInteger iPosX;
    public BigInteger iPosY;

    public AsnSubmapPos() {
    }

    public AsnSubmapPos(AsnSubmapPos arg) {
        this.strSubmapID = new byte[arg.strSubmapID.length];
        System.arraycopy(arg.strSubmapID, 0, this.strSubmapID, 0, arg.strSubmapID.length);
        this.iPosX = arg.iPosX;
        this.iPosY = arg.iPosY;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strSubmapID);
        enc.serializeInteger(this.iPosX);
        enc.serializeInteger(this.iPosY);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strSubmapID = dec.deserializeOctetString();
        this.iPosX = dec.deserializeInteger();
        this.iPosY = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSubmapID = ");
        os.print(FStruFormat.convertToString((byte[])this.strSubmapID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPosX = ");
        os.print(this.iPosX.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPosY = ");
        os.print(this.iPosY.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

