/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnSearchNodeInt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSearchNode
implements FStruct {
    public AsnSearchNodeInt iMatch = new AsnSearchNodeInt();
    public byte[] strLabel = null;
    public byte[] strDevIP = null;
    public byte[] strDevMAC = null;
    public BigInteger iCase = null;

    public AsnSearchNode() {
    }

    public AsnSearchNode(AsnSearchNode arg) {
        this.iMatch = new AsnSearchNodeInt(arg.iMatch);
        if (arg.strLabel != null) {
            this.strLabel = new byte[arg.strLabel.length];
            System.arraycopy(arg.strLabel, 0, this.strLabel, 0, arg.strLabel.length);
        }
        if (arg.strDevIP != null) {
            this.strDevIP = new byte[arg.strDevIP.length];
            System.arraycopy(arg.strDevIP, 0, this.strDevIP, 0, arg.strDevIP.length);
        }
        if (arg.strDevMAC != null) {
            this.strDevMAC = new byte[arg.strDevMAC.length];
            System.arraycopy(arg.strDevMAC, 0, this.strDevMAC, 0, arg.strDevMAC.length);
        }
        if (arg.iCase != null) {
            this.iCase = arg.iCase;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.iMatch.serialize(enc);
        if (this.strLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strLabel);
        }
        if (this.strDevIP != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strDevIP);
        }
        if (this.strDevMAC != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.strDevMAC);
        }
        if (this.iCase != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.iCase);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iMatch.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strDevIP = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.strDevMAC = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.iCase = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iMatch = ");
        this.iMatch.print(os, indent + 2);
        os.println(',');
        if (this.strLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strLabel));
            os.println(',');
        }
        if (this.strDevIP != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDevIP = ");
            os.print(FStruFormat.convertToString((byte[])this.strDevIP));
            os.println(',');
        }
        if (this.strDevMAC != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strDevMAC = ");
            os.print(FStruFormat.convertToString((byte[])this.strDevMAC));
            os.println(',');
        }
        if (this.iCase != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iCase = ");
            os.print(this.iCase.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

