/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnSMToken;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSMUserCheckReq
implements FStruct {
    public AsnSMToken token = new AsnSMToken();
    public byte[] userName;
    public byte[] password;

    public AsnSMUserCheckReq() {
    }

    public AsnSMUserCheckReq(AsnSMUserCheckReq arg) {
        this.token = new AsnSMToken(arg.token);
        this.userName = new byte[arg.userName.length];
        System.arraycopy(arg.userName, 0, this.userName, 0, arg.userName.length);
        this.password = new byte[arg.password.length];
        System.arraycopy(arg.password, 0, this.password, 0, arg.password.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.token.serialize(enc);
        enc.serializeOctetString(this.userName);
        enc.serializeOctetString(this.password);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.token.deserialize(dec);
        this.userName = dec.deserializeOctetString();
        this.password = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("token = ");
        this.token.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userName = ");
        os.print(FStruFormat.convertToString((byte[])this.userName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("password = ");
        os.print(FStruFormat.convertToString((byte[])this.password));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

