/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnSMToken;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSMLoginoutReq
implements FStruct {
    public AsnSMToken token = new AsnSMToken();
    public byte[] terminalID = null;

    public AsnSMLoginoutReq() {
    }

    public AsnSMLoginoutReq(AsnSMLoginoutReq arg) {
        this.token = new AsnSMToken(arg.token);
        if (arg.terminalID != null) {
            this.terminalID = new byte[arg.terminalID.length];
            System.arraycopy(arg.terminalID, 0, this.terminalID, 0, arg.terminalID.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.token.serialize(enc);
        if (this.terminalID != null) {
            enc.serializeOctetString(this.terminalID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.token.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)4))) {
            this.terminalID = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("token = ");
        this.token.print(os, indent + 2);
        os.println(',');
        if (this.terminalID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("terminalID = ");
            os.print(FStruFormat.convertToString((byte[])this.terminalID));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

