/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.SMUser;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnSMLoginReq
implements FStruct {
    public SMUser user = new SMUser();
    public byte[] pwd;
    public BigInteger clientType;
    public byte[] terminalID;

    public AsnSMLoginReq() {
    }

    public AsnSMLoginReq(AsnSMLoginReq arg) {
        this.user = new SMUser(arg.user);
        this.pwd = new byte[arg.pwd.length];
        System.arraycopy(arg.pwd, 0, this.pwd, 0, arg.pwd.length);
        this.clientType = arg.clientType;
        this.terminalID = new byte[arg.terminalID.length];
        System.arraycopy(arg.terminalID, 0, this.terminalID, 0, arg.terminalID.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.user.serialize(enc);
        enc.serializeOctetString(this.pwd);
        enc.serializeInteger(this.clientType);
        enc.serializeOctetString(this.terminalID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.user.deserialize(dec);
        this.pwd = dec.deserializeOctetString();
        this.clientType = dec.deserializeInteger();
        this.terminalID = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("user = ");
        this.user.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pwd = ");
        os.print(FStruFormat.convertToString((byte[])this.pwd));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clientType = ");
        os.print(this.clientType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("terminalID = ");
        os.print(FStruFormat.convertToString((byte[])this.terminalID));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

