/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnResourceTabSeqOf;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnResourceTab
implements FStruct {
    public byte[] aResDN;
    public BigInteger iResMainType;
    public BigInteger iResSubType;
    public BigInteger iResNumber;
    public AsnResourceTabSeqOf aResAttrTab = null;
    public byte[] wholeLabel = null;

    public AsnResourceTab() {
    }

    public AsnResourceTab(AsnResourceTab arg) {
        this.aResDN = new byte[arg.aResDN.length];
        System.arraycopy(arg.aResDN, 0, this.aResDN, 0, arg.aResDN.length);
        this.iResMainType = arg.iResMainType;
        this.iResSubType = arg.iResSubType;
        this.iResNumber = arg.iResNumber;
        if (arg.aResAttrTab != null) {
            this.aResAttrTab = new AsnResourceTabSeqOf(arg.aResAttrTab);
        }
        if (arg.wholeLabel != null) {
            this.wholeLabel = new byte[arg.wholeLabel.length];
            System.arraycopy(arg.wholeLabel, 0, this.wholeLabel, 0, arg.wholeLabel.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.aResDN);
        enc.serializeInteger(this.iResMainType);
        enc.serializeInteger(this.iResSubType);
        enc.serializeInteger(this.iResNumber);
        if (this.aResAttrTab != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.aResAttrTab.serialize(enc);
        }
        if (this.wholeLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.wholeLabel);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.aResDN = dec.deserializeOctetString();
        this.iResMainType = dec.deserializeInteger();
        this.iResSubType = dec.deserializeInteger();
        this.iResNumber = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.aResAttrTab = new AsnResourceTabSeqOf();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.aResAttrTab.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.wholeLabel = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("aResDN = ");
        os.print(FStruFormat.convertToString((byte[])this.aResDN));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResMainType = ");
        os.print(this.iResMainType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResSubType = ");
        os.print(this.iResSubType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iResNumber = ");
        os.print(this.iResNumber.toString());
        os.println(',');
        if (this.aResAttrTab != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("aResAttrTab = ");
            this.aResAttrTab.print(os, indent + 2);
            os.println(',');
        }
        if (this.wholeLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("wholeLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.wholeLabel));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

