/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnResAttrList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnResourceNotify
implements FStruct {
    public byte[] resDN;
    public byte[] label = null;
    public BigInteger maintype = null;
    public BigInteger subtype = null;
    public BigInteger iResNumber = null;
    public AsnResAttrList lstattr = null;
    public BigInteger iid = null;
    public BigInteger userid = null;

    public AsnResourceNotify() {
    }

    public AsnResourceNotify(AsnResourceNotify arg) {
        this.resDN = new byte[arg.resDN.length];
        System.arraycopy(arg.resDN, 0, this.resDN, 0, arg.resDN.length);
        if (arg.label != null) {
            this.label = new byte[arg.label.length];
            System.arraycopy(arg.label, 0, this.label, 0, arg.label.length);
        }
        if (arg.maintype != null) {
            this.maintype = arg.maintype;
        }
        if (arg.subtype != null) {
            this.subtype = arg.subtype;
        }
        if (arg.iResNumber != null) {
            this.iResNumber = arg.iResNumber;
        }
        if (arg.lstattr != null) {
            this.lstattr = new AsnResAttrList(arg.lstattr);
        }
        if (arg.iid != null) {
            this.iid = arg.iid;
        }
        if (arg.userid != null) {
            this.userid = arg.userid;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.resDN);
        if (this.label != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.label);
        }
        if (this.maintype != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.maintype);
        }
        if (this.subtype != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.subtype);
        }
        if (this.iResNumber != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.iResNumber);
        }
        if (this.lstattr != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            this.lstattr.serialize(enc);
        }
        if (this.iid != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeInteger(this.iid);
        }
        if (this.userid != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeInteger(this.userid);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.resDN = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.label = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.maintype = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.subtype = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.iResNumber = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            this.lstattr = new AsnResAttrList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.lstattr.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.iid = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.userid = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resDN = ");
        os.print(FStruFormat.convertToString((byte[])this.resDN));
        os.println(',');
        if (this.label != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("label = ");
            os.print(FStruFormat.convertToString((byte[])this.label));
            os.println(',');
        }
        if (this.maintype != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("maintype = ");
            os.print(this.maintype.toString());
            os.println(',');
        }
        if (this.subtype != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("subtype = ");
            os.print(this.subtype.toString());
            os.println(',');
        }
        if (this.iResNumber != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iResNumber = ");
            os.print(this.iResNumber.toString());
            os.println(',');
        }
        if (this.lstattr != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("lstattr = ");
            this.lstattr.print(os, indent + 2);
            os.println(',');
        }
        if (this.iid != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iid = ");
            os.print(this.iid.toString());
            os.println(',');
        }
        if (this.userid != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("userid = ");
            os.print(this.userid.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

