/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnResSubTypeTab
implements FStruct {
    public BigInteger iMainTypeID;
    public BigInteger iSubTypeID;
    public byte[] strName;

    public AsnResSubTypeTab() {
    }

    public AsnResSubTypeTab(AsnResSubTypeTab arg) {
        this.iMainTypeID = arg.iMainTypeID;
        this.iSubTypeID = arg.iSubTypeID;
        this.strName = new byte[arg.strName.length];
        System.arraycopy(arg.strName, 0, this.strName, 0, arg.strName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iMainTypeID);
        enc.serializeInteger(this.iSubTypeID);
        enc.serializeOctetString(this.strName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iMainTypeID = dec.deserializeInteger();
        this.iSubTypeID = dec.deserializeInteger();
        this.strName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iMainTypeID = ");
        os.print(this.iMainTypeID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSubTypeID = ");
        os.print(this.iSubTypeID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strName = ");
        os.print(FStruFormat.convertToString((byte[])this.strName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

