/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnResIfDevInfo
implements FStruct {
    public BigInteger iDevID;
    public byte[] strDevIPAddr;
    public byte[] strDevMACAddr;
    public byte[] strDevName;

    public AsnResIfDevInfo() {
    }

    public AsnResIfDevInfo(AsnResIfDevInfo arg) {
        this.iDevID = arg.iDevID;
        this.strDevIPAddr = new byte[arg.strDevIPAddr.length];
        System.arraycopy(arg.strDevIPAddr, 0, this.strDevIPAddr, 0, arg.strDevIPAddr.length);
        this.strDevMACAddr = new byte[arg.strDevMACAddr.length];
        System.arraycopy(arg.strDevMACAddr, 0, this.strDevMACAddr, 0, arg.strDevMACAddr.length);
        this.strDevName = new byte[arg.strDevName.length];
        System.arraycopy(arg.strDevName, 0, this.strDevName, 0, arg.strDevName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDevID);
        enc.serializeOctetString(this.strDevIPAddr);
        enc.serializeOctetString(this.strDevMACAddr);
        enc.serializeOctetString(this.strDevName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDevID = dec.deserializeInteger();
        this.strDevIPAddr = dec.deserializeOctetString();
        this.strDevMACAddr = dec.deserializeOctetString();
        this.strDevName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevIPAddr = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevIPAddr));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevMACAddr = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevMACAddr));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevName = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

