/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.ASNUCList;
import com.swimap.imap.common.asn1.common.ASNULList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnOtherToFMRegisteEFDCondition
implements FStruct {
    public BigInteger lNodeType;
    public BigInteger cDevType;
    public ASNUCList lstFaultClass = new ASNUCList();
    public ASNUCList lstFaultLevel = new ASNUCList();
    public ASNUCList lstFaultFunction = new ASNUCList();
    public ASNULList lstFaultID = new ASNULList();
    public byte[] strFdn;
    public BigInteger cEnableRule = null;

    public AsnOtherToFMRegisteEFDCondition() {
    }

    public AsnOtherToFMRegisteEFDCondition(AsnOtherToFMRegisteEFDCondition arg) {
        this.lNodeType = arg.lNodeType;
        this.cDevType = arg.cDevType;
        this.lstFaultClass = new ASNUCList(arg.lstFaultClass);
        this.lstFaultLevel = new ASNUCList(arg.lstFaultLevel);
        this.lstFaultFunction = new ASNUCList(arg.lstFaultFunction);
        this.lstFaultID = new ASNULList(arg.lstFaultID);
        this.strFdn = new byte[arg.strFdn.length];
        System.arraycopy(arg.strFdn, 0, this.strFdn, 0, arg.strFdn.length);
        if (arg.cEnableRule != null) {
            this.cEnableRule = arg.cEnableRule;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.lNodeType);
        enc.serializeInteger(this.cDevType);
        this.lstFaultClass.serialize(enc);
        this.lstFaultLevel.serialize(enc);
        this.lstFaultFunction.serialize(enc);
        this.lstFaultID.serialize(enc);
        enc.serializeOctetString(this.strFdn);
        if (this.cEnableRule != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.cEnableRule);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lNodeType = dec.deserializeInteger();
        this.cDevType = dec.deserializeInteger();
        this.lstFaultClass.deserialize(dec);
        this.lstFaultLevel.deserialize(dec);
        this.lstFaultFunction.deserialize(dec);
        this.lstFaultID.deserialize(dec);
        this.strFdn = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.cEnableRule = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lNodeType = ");
        os.print(this.lNodeType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cDevType = ");
        os.print(this.cDevType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstFaultClass = ");
        this.lstFaultClass.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstFaultLevel = ");
        this.lstFaultLevel.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstFaultFunction = ");
        this.lstFaultFunction.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstFaultID = ");
        this.lstFaultID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFdn = ");
        os.print(FStruFormat.convertToString((byte[])this.strFdn));
        os.println(',');
        if (this.cEnableRule != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("cEnableRule = ");
            os.print(this.cEnableRule.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

