/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.ASNULList;
import com.swimap.imap.common.asn1.common.AsnTopoOIDList;
import com.swimap.imap.common.asn1.common.AsniFMSDateTimeStrc;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnOtherOperateFaultStrcReq
implements FStruct {
    public ASNULList lstSerialNo = new ASNULList();
    public AsnTopoOIDList lstTopoOID = new AsnTopoOIDList();
    public BigInteger lOperateType;
    public BigInteger lUserID = null;
    public byte[] strUserName = null;
    public AsniFMSDateTimeStrc faultDateTm = null;

    public AsnOtherOperateFaultStrcReq() {
    }

    public AsnOtherOperateFaultStrcReq(AsnOtherOperateFaultStrcReq arg) {
        this.lstSerialNo = new ASNULList(arg.lstSerialNo);
        this.lstTopoOID = new AsnTopoOIDList(arg.lstTopoOID);
        this.lOperateType = arg.lOperateType;
        if (arg.lUserID != null) {
            this.lUserID = arg.lUserID;
        }
        if (arg.strUserName != null) {
            this.strUserName = new byte[arg.strUserName.length];
            System.arraycopy(arg.strUserName, 0, this.strUserName, 0, arg.strUserName.length);
        }
        if (arg.faultDateTm != null) {
            this.faultDateTm = new AsniFMSDateTimeStrc(arg.faultDateTm);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.lstSerialNo.serialize(enc);
        this.lstTopoOID.serialize(enc);
        enc.serializeInteger(this.lOperateType);
        if (this.lUserID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.lUserID);
        }
        if (this.strUserName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strUserName);
        }
        if (this.faultDateTm != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.faultDateTm.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lstSerialNo.deserialize(dec);
        this.lstTopoOID.deserialize(dec);
        this.lOperateType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.lUserID = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strUserName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.faultDateTm = new AsniFMSDateTimeStrc();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.faultDateTm.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstSerialNo = ");
        this.lstSerialNo.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstTopoOID = ");
        this.lstTopoOID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lOperateType = ");
        os.print(this.lOperateType.toString());
        os.println(',');
        if (this.lUserID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("lUserID = ");
            os.print(this.lUserID.toString());
            os.println(',');
        }
        if (this.strUserName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strUserName = ");
            os.print(FStruFormat.convertToString((byte[])this.strUserName));
            os.println(',');
        }
        if (this.faultDateTm != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("faultDateTm = ");
            this.faultDateTm.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

