/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnNotifySubmapCreate
implements FStruct {
    public BigInteger iUserID;
    public byte[] strParentSubmapID;
    public byte[] strSubmapID;

    public AsnNotifySubmapCreate() {
    }

    public AsnNotifySubmapCreate(AsnNotifySubmapCreate arg) {
        this.iUserID = arg.iUserID;
        this.strParentSubmapID = new byte[arg.strParentSubmapID.length];
        System.arraycopy(arg.strParentSubmapID, 0, this.strParentSubmapID, 0, arg.strParentSubmapID.length);
        this.strSubmapID = new byte[arg.strSubmapID.length];
        System.arraycopy(arg.strSubmapID, 0, this.strSubmapID, 0, arg.strSubmapID.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iUserID);
        enc.serializeOctetString(this.strParentSubmapID);
        enc.serializeOctetString(this.strSubmapID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iUserID = dec.deserializeInteger();
        this.strParentSubmapID = dec.deserializeOctetString();
        this.strSubmapID = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iUserID = ");
        os.print(this.iUserID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strParentSubmapID = ");
        os.print(FStruFormat.convertToString((byte[])this.strParentSubmapID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strSubmapID = ");
        os.print(FStruFormat.convertToString((byte[])this.strSubmapID));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

