/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnNotifyAddTrapReceiver
implements FStruct {
    public BigInteger trapReceiverId;
    public byte[] trapReceiverIp;
    public BigInteger trapReceiverLstPort;
    public BigInteger trapReceiverUdpPort;

    public AsnNotifyAddTrapReceiver() {
    }

    public AsnNotifyAddTrapReceiver(AsnNotifyAddTrapReceiver arg) {
        this.trapReceiverId = arg.trapReceiverId;
        this.trapReceiverIp = new byte[arg.trapReceiverIp.length];
        System.arraycopy(arg.trapReceiverIp, 0, this.trapReceiverIp, 0, arg.trapReceiverIp.length);
        this.trapReceiverLstPort = arg.trapReceiverLstPort;
        this.trapReceiverUdpPort = arg.trapReceiverUdpPort;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.trapReceiverId);
        enc.serializeOctetString(this.trapReceiverIp);
        enc.serializeInteger(this.trapReceiverLstPort);
        enc.serializeInteger(this.trapReceiverUdpPort);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.trapReceiverId = dec.deserializeInteger();
        this.trapReceiverIp = dec.deserializeOctetString();
        this.trapReceiverLstPort = dec.deserializeInteger();
        this.trapReceiverUdpPort = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trapReceiverId = ");
        os.print(this.trapReceiverId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trapReceiverIp = ");
        os.print(FStruFormat.convertToString((byte[])this.trapReceiverIp));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trapReceiverLstPort = ");
        os.print(this.trapReceiverLstPort.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trapReceiverUdpPort = ");
        os.print(this.trapReceiverUdpPort.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

