/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.ASNULList;
import com.swimap.imap.common.asn1.common.AsnMAPTMKEY2SVAL;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnNodeAttr
implements FStruct {
    public byte[] strParentSubmapID;
    public byte[] strNodeID;
    public byte[] strLabel = null;
    public byte[] strSymbolType = null;
    public BigInteger iFixFlag = null;
    public byte[] strComment = null;
    public ASNULList iRoleType = null;
    public byte[] strNodeType = null;
    public BigInteger iViewID = null;
    public byte[] strNodeAlias = null;
    public AsnMAPTMKEY2SVAL asnKey2Val = null;

    public AsnNodeAttr() {
    }

    public AsnNodeAttr(AsnNodeAttr arg) {
        this.strParentSubmapID = new byte[arg.strParentSubmapID.length];
        System.arraycopy(arg.strParentSubmapID, 0, this.strParentSubmapID, 0, arg.strParentSubmapID.length);
        this.strNodeID = new byte[arg.strNodeID.length];
        System.arraycopy(arg.strNodeID, 0, this.strNodeID, 0, arg.strNodeID.length);
        if (arg.strLabel != null) {
            this.strLabel = new byte[arg.strLabel.length];
            System.arraycopy(arg.strLabel, 0, this.strLabel, 0, arg.strLabel.length);
        }
        if (arg.strSymbolType != null) {
            this.strSymbolType = new byte[arg.strSymbolType.length];
            System.arraycopy(arg.strSymbolType, 0, this.strSymbolType, 0, arg.strSymbolType.length);
        }
        if (arg.iFixFlag != null) {
            this.iFixFlag = arg.iFixFlag;
        }
        if (arg.strComment != null) {
            this.strComment = new byte[arg.strComment.length];
            System.arraycopy(arg.strComment, 0, this.strComment, 0, arg.strComment.length);
        }
        if (arg.iRoleType != null) {
            this.iRoleType = new ASNULList(arg.iRoleType);
        }
        if (arg.strNodeType != null) {
            this.strNodeType = new byte[arg.strNodeType.length];
            System.arraycopy(arg.strNodeType, 0, this.strNodeType, 0, arg.strNodeType.length);
        }
        if (arg.iViewID != null) {
            this.iViewID = arg.iViewID;
        }
        if (arg.strNodeAlias != null) {
            this.strNodeAlias = new byte[arg.strNodeAlias.length];
            System.arraycopy(arg.strNodeAlias, 0, this.strNodeAlias, 0, arg.strNodeAlias.length);
        }
        if (arg.asnKey2Val != null) {
            this.asnKey2Val = new AsnMAPTMKEY2SVAL(arg.asnKey2Val);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strParentSubmapID);
        enc.serializeOctetString(this.strNodeID);
        if (this.strLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strLabel);
        }
        if (this.strSymbolType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strSymbolType);
        }
        if (this.iFixFlag != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iFixFlag);
        }
        if (this.strComment != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeOctetString(this.strComment);
        }
        if (this.iRoleType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            this.iRoleType.serialize(enc);
        }
        if (this.strNodeType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeOctetString(this.strNodeType);
        }
        if (this.iViewID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeInteger(this.iViewID);
        }
        if (this.strNodeAlias != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)7));
            enc.serializeOctetString(this.strNodeAlias);
        }
        if (this.asnKey2Val != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)8));
            this.asnKey2Val.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strParentSubmapID = dec.deserializeOctetString();
        this.strNodeID = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strSymbolType = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.iFixFlag = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.strComment = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            this.iRoleType = new ASNULList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.iRoleType.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.strNodeType = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.iViewID = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)7))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)7));
            this.strNodeAlias = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)8))) {
            this.asnKey2Val = new AsnMAPTMKEY2SVAL();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)8));
            this.asnKey2Val.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strParentSubmapID = ");
        os.print(FStruFormat.convertToString((byte[])this.strParentSubmapID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strNodeID = ");
        os.print(FStruFormat.convertToString((byte[])this.strNodeID));
        os.println(',');
        if (this.strLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strLabel));
            os.println(',');
        }
        if (this.strSymbolType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strSymbolType = ");
            os.print(FStruFormat.convertToString((byte[])this.strSymbolType));
            os.println(',');
        }
        if (this.iFixFlag != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iFixFlag = ");
            os.print(this.iFixFlag.toString());
            os.println(',');
        }
        if (this.strComment != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strComment = ");
            os.print(FStruFormat.convertToString((byte[])this.strComment));
            os.println(',');
        }
        if (this.iRoleType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iRoleType = ");
            this.iRoleType.print(os, indent + 2);
            os.println(',');
        }
        if (this.strNodeType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strNodeType = ");
            os.print(FStruFormat.convertToString((byte[])this.strNodeType));
            os.println(',');
        }
        if (this.iViewID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iViewID = ");
            os.print(this.iViewID.toString());
            os.println(',');
        }
        if (this.strNodeAlias != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strNodeAlias = ");
            os.print(FStruFormat.convertToString((byte[])this.strNodeAlias));
            os.println(',');
        }
        if (this.asnKey2Val != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("asnKey2Val = ");
            this.asnKey2Val.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

